/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.listeners.crates.types;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.tasks.menus.CratePrizeMenu;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class WarCrateListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        final Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof CratePrizeMenu)) {
            return;
        }
        CratePrizeMenu holder = (CratePrizeMenu)inventoryHolder;
        final Player player = holder.getPlayer();
        event.setCancelled(true);
        if (!this.crateManager.isPicker(player)) {
            return;
        }
        if (!this.crateManager.isInOpeningList(player)) {
            return;
        }
        final Crate crate = this.crateManager.getOpeningCrate(player);
        if (crate.getCrateType() != CrateType.war) {
            return;
        }
        if (!item.getType().toString().contains(Material.GLASS_PANE.toString())) {
            return;
        }
        final int slot = event.getRawSlot();
        Prize prize = crate.pickPrize(player);
        inventory.setItem(slot, prize.getDisplayItem(player, crate));
        if (this.crateManager.hasCrateTask(player)) {
            this.crateManager.endCrate(player);
        }
        this.crateManager.removePicker(player);
        this.crateManager.addCloser(player, true);
        PrizeManager.givePrize(player, crate, prize);
        this.crateManager.removePlayerFromOpeningList(player);
        crate.playSound(player, player.getLocation(), "cycle-sound", "block.anvil.land", Sound.Source.MASTER);
        this.crateManager.addCrateTask(player, new FoliaScheduler(this.plugin, null, (Entity)player){

            @Override
            public void run() {
                for (int i = 0; i < 9; ++i) {
                    if (i == slot) continue;
                    inventory.setItem(i, crate.pickPrize(player).getDisplayItem(player, crate));
                }
                if (WarCrateListener.this.crateManager.hasCrateTask(player)) {
                    WarCrateListener.this.crateManager.endCrate(player);
                }
                WarCrateListener.this.crateManager.addCrateTask(player, new FoliaScheduler(WarCrateListener.this.plugin, null, (Entity)player){

                    @Override
                    public void run() {
                        for (int i = 0; i < 9; ++i) {
                            if (i == slot) continue;
                            inventory.setItem(i, null);
                        }
                        if (WarCrateListener.this.crateManager.hasCrateTask(player)) {
                            WarCrateListener.this.crateManager.endCrate(player);
                        }
                        WarCrateListener.this.crateManager.addCrateTask(player, new FoliaScheduler(WarCrateListener.this.plugin, null, (Entity)player){

                            @Override
                            public void run() {
                                if (WarCrateListener.this.crateManager.hasCrateTask(player)) {
                                    WarCrateListener.this.crateManager.endCrate(player);
                                }
                                WarCrateListener.this.crateManager.removePlayerFromOpeningList(player);
                                player.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
                            }
                        }.runDelayed(30L));
                    }
                }.runDelayed(30L));
            }
        }.runDelayed(30L));
    }
}

