/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.listeners.crates.types;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.events.PlayerReceiveKeyEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.events.EventManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.tasks.crates.other.CosmicCrateManager;
import com.badbones69.crazycrates.paper.tasks.menus.CratePrizeMenu;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CosmicCrateListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    private final Server server = this.plugin.getServer();
    private final PluginManager pluginManager = this.server.getPluginManager();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final BukkitUserManager userManager = this.plugin.getUserManager();
    private final SettingsManager config = ConfigManager.getConfig();

    @EventHandler
    public void onPrizeReceive(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof CratePrizeMenu)) {
            return;
        }
        CratePrizeMenu holder = (CratePrizeMenu)inventoryHolder;
        Player player = holder.getPlayer();
        event.setCancelled(true);
        Crate crate = this.crateManager.getOpeningCrate(player);
        if (crate == null) {
            return;
        }
        if (!this.crateManager.isInOpeningList(player) || crate.getCrateType() != CrateType.cosmic) {
            return;
        }
        if (!holder.contains(" - Prizes")) {
            return;
        }
        int slot = event.getRawSlot();
        if (this.crateManager.containsSlot(player) && this.crateManager.getSlots(player).contains(slot)) {
            Messages.already_redeemed_prize.sendMessage((CommandSender)player);
            return;
        }
        InventoryView view = event.getView();
        Inventory topInventory = view.getTopInventory();
        if (event.getClickedInventory() != topInventory) {
            return;
        }
        ItemStack itemStack = topInventory.getItem(slot);
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        Tier tier = this.crateManager.getTier(player, slot);
        if (tier == null) {
            return;
        }
        Prize prize = crate.pickPrize(player, tier);
        for (int stop = 0; prize == null && stop <= 2000; ++stop) {
            prize = crate.pickPrize(player, tier);
        }
        if (prize == null) {
            return;
        }
        PrizeManager.givePrize(player, crate, prize);
        event.setCurrentItem(prize.getDisplayItem(player, crate));
        crate.playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.MASTER);
        this.crateManager.addSlot(player, slot);
    }

    @EventHandler
    public void onMysteryBoxClick(final InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof CratePrizeMenu)) {
            return;
        }
        final CratePrizeMenu holder = (CratePrizeMenu)inventoryHolder;
        final Player player = holder.getPlayer();
        final UUID uuid = player.getUniqueId();
        event.setCancelled(true);
        final Crate crate = this.crateManager.getOpeningCrate(player);
        if (crate == null) {
            return;
        }
        if (!this.crateManager.isInOpeningList(player) || crate.getCrateType() != CrateType.cosmic) {
            return;
        }
        if (!holder.contains(" - Choose")) {
            return;
        }
        int slot = event.getRawSlot();
        final InventoryView view = event.getView();
        Inventory topInventory = view.getTopInventory();
        if (event.getClickedInventory() != topInventory) {
            return;
        }
        ItemStack itemStack = topInventory.getItem(slot);
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        final CosmicCrateManager cosmicCrateManager = (CosmicCrateManager)crate.getManager();
        int totalPrizes = cosmicCrateManager.getTotalPrizes();
        int pickedSlot = slot + 1;
        PersistentDataContainerView container = itemStack.getPersistentDataContainer();
        if (container.has(ItemKeys.cosmic_mystery_crate.getNamespacedKey())) {
            int size = cosmicCrateManager.getPrizes(player).size();
            if (size < totalPrizes) {
                Tier tier = this.crateManager.getTier(player, slot);
                if (tier == null) {
                    return;
                }
                tierName = tier.getName();
                LegacyItemBuilder builder = (LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)cosmicCrateManager.getPickedCrate().setPlayer(player)).addNamePlaceholder("%Slot%", String.valueOf(pickedSlot))).addLorePlaceholder("%Slot%", String.valueOf(pickedSlot));
                builder.setAmount(pickedSlot);
                cosmicCrateManager.setTier(builder, tierName);
                event.setCurrentItem(builder.asItemStack());
                cosmicCrateManager.addPickedPrize(player, slot, tier);
                crate.playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.MASTER);
            }
        } else if (container.has(ItemKeys.cosmic_picked_crate.getNamespacedKey())) {
            Tier tier = this.crateManager.getTier(player, slot);
            LegacyItemBuilder builder = (LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)cosmicCrateManager.getMysteryCrate().setPlayer(player)).addNamePlaceholder("%Slot%", String.valueOf(pickedSlot))).addLorePlaceholder("%Slot%", String.valueOf(pickedSlot));
            builder.setAmount(pickedSlot);
            tierName = tier.getName();
            cosmicCrateManager.setTier(builder, tierName);
            event.setCurrentItem(builder.asItemStack());
            cosmicCrateManager.removePickedPrize(player, slot);
            crate.playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.MASTER);
        }
        final String fileName = crate.getFileName();
        final String fancyName = crate.getCrateName();
        int size = cosmicCrateManager.getPrizes(player).size();
        if (size >= totalPrizes) {
            boolean cannotTakeKey;
            boolean value;
            KeyType playerType = this.crateManager.getPlayerKeyType(player);
            final KeyType type = playerType == null ? KeyType.virtual_key : playerType;
            boolean bl = value = type == KeyType.physical_key && !this.userManager.hasPhysicalKey(uuid, fileName, this.crateManager.getHand(player));
            if (value) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("{crate}", fancyName);
                placeholders.put("{key}", crate.getKeyName());
                Messages.no_keys.sendMessage((CommandSender)player, placeholders);
                this.crateManager.removePlayerFromOpeningList(player);
                this.crateManager.removePlayerKeyType(player);
                this.crateManager.removeTier(player);
                this.crateManager.removeHands(player);
                cosmicCrateManager.removePickedPlayer(player);
                player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                return;
            }
            boolean bl2 = this.crateManager.hasPlayerKeyType(player) && !this.userManager.takeKeys(uuid, fileName, type, crate.useRequiredKeys() ? crate.getRequiredKeys() : 1, this.crateManager.getHand(player)) ? true : (cannotTakeKey = false);
            if (cannotTakeKey) {
                MiscUtils.failedToTakeKey((CommandSender)player, fileName);
                this.crateManager.removePlayerFromOpeningList(player);
                this.crateManager.removePlayerKeyType(player);
                this.crateManager.removeTier(player);
                this.crateManager.removeHands(player);
                cosmicCrateManager.removePickedPlayer(player);
                player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                return;
            }
            String shufflingName = fancyName + " - Shuffling";
            holder.title(shufflingName);
            holder.sendTitleChange();
            view.getTopInventory().clear();
            YamlConfiguration configuration = crate.getFile();
            String broadcastMessage = configuration.getString("Crate.BroadCast", "");
            boolean broadcastToggle = configuration.getBoolean("Crate.OpeningBroadCast", false);
            if (broadcastToggle && !broadcastMessage.isBlank()) {
                String builder = Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)broadcastMessage) : broadcastMessage;
                this.server.broadcast(AdvUtils.parse(builder.replaceAll("%crate%", fancyName).replaceAll("%prefix%", this.config.getProperty(ConfigKeys.command_prefix)).replaceAll("%player%", player.getName())));
            }
            EventManager.logEvent(EventType.event_crate_opened, player.getName(), (CommandSender)player, crate, type, 1);
            this.crateManager.addRepeatingCrateTask(player, new TimerTask(){
                int time = 0;

                @Override
                public void run() {
                    try {
                        CosmicCrateListener.this.startRollingAnimation(player, view, holder);
                    }
                    catch (Exception exception) {
                        new FoliaScheduler(CosmicCrateListener.this.plugin, null, (Entity)player){

                            @Override
                            public void run() {
                                PlayerReceiveKeyEvent keyEvent = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.REFUND, 1);
                                CosmicCrateListener.this.pluginManager.callEvent((Event)keyEvent);
                                if (!event.isCancelled()) {
                                    CosmicCrateListener.this.userManager.addKeys(uuid, fileName, type, 1);
                                    CosmicCrateListener.this.crateManager.removePlayerFromOpeningList(player);
                                    CosmicCrateListener.this.crateManager.removePlayerKeyType(player);
                                    CosmicCrateListener.this.crateManager.removeTier(player);
                                    CosmicCrateListener.this.crateManager.removeCrateTask(player);
                                    CosmicCrateListener.this.crateManager.removeHands(player);
                                    cosmicCrateManager.removePickedPlayer(player);
                                    Messages.key_refund.sendMessage((CommandSender)player, "{crate}", fancyName);
                                    if (MiscUtils.isLogging()) {
                                        CosmicCrateListener.this.logger.error("An issue occurred when the user {} was using the {} crate and so they were issued a key refund.", new Object[]{player.getName(), fileName, exception});
                                    }
                                    crate.playSound(player, player.getLocation(), "stop-sound", "block.anvil.place", Sound.Source.MASTER);
                                }
                            }
                        }.runNow();
                        this.cancel();
                        return;
                    }
                    ++this.time;
                    if (this.time == 40) {
                        CosmicCrateListener.this.crateManager.removeCrateTask(player);
                        CosmicCrateListener.this.showRewards(player, view, holder, cosmicCrateManager);
                        crate.playSound(player, player.getLocation(), "stop-sound", "block.anvil.place", Sound.Source.MASTER);
                        this.cancel();
                    }
                }
            }, 0L, 80L);
        }
    }

    private void startRollingAnimation(@NotNull Player player, @NotNull InventoryView view, @NotNull CratePrizeMenu cosmic) {
        Crate crate = cosmic.getCrate();
        for (int slot = 0; slot < cosmic.getSize(); ++slot) {
            Tier tier = PrizeManager.getTier(crate);
            if (tier == null) continue;
            view.getTopInventory().setItem(slot, tier.getTierItem(player, crate));
        }
        crate.playSound(player, player.getLocation(), "cycle-sound", "block.note_block.xylophone", Sound.Source.MASTER);
        player.updateInventory();
    }

    private void showRewards(final @NotNull Player player, @NotNull InventoryView view, @NotNull CratePrizeMenu cosmic, @NotNull CosmicCrateManager cosmicCrateManager) {
        Crate crate = cosmic.getCrate();
        String rewardsName = crate.getCrateName() + " - Prizes";
        cosmic.title(rewardsName);
        cosmic.sendTitleChange();
        view.getTopInventory().clear();
        cosmicCrateManager.getPrizes(player).forEach((slot, tier) -> view.getTopInventory().setItem(slot.intValue(), tier.getTierItem(player, crate)));
        player.updateInventory();
        if (ConfigManager.getConfig().getProperty(ConfigKeys.cosmic_crate_timeout).booleanValue()) {
            this.crateManager.addCrateTask(player, new TimerTask(){

                @Override
                public void run() {
                    new FoliaScheduler(CosmicCrateListener.this.plugin, null, (Entity)player){

                        @Override
                        public void run() {
                            player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                        }
                    }.runNow();
                    if (MiscUtils.isLogging()) {
                        List.of(player.getName() + " spent 10 seconds staring at a gui instead of collecting their prizes", "The task has been cancelled, They have been given their prizes and the gui is closed.").forEach(arg_0 -> ((ComponentLogger)CosmicCrateListener.this.logger).info(arg_0));
                    }
                }
            }, 10000L);
        }
    }
}

