/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.listeners.crates;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.events.CrateOpenEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.events.EventManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.List;
import libs.com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CrateOpenListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final Server server = this.plugin.getServer();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final BukkitUserManager userManager = this.plugin.getUserManager();
    private final SettingsManager config = ConfigManager.getConfig();

    @EventHandler
    public void onCrateOpen(CrateOpenEvent event) {
        List commands;
        boolean commandToggle;
        Player player = event.getPlayer();
        String playerName = player.getName();
        Crate crate = event.getCrate();
        String fileName = crate.getFileName();
        String fancyName = crate.getCrateName();
        CrateType crateType = crate.getCrateType();
        if (crateType != CrateType.menu && (crate.getPrizes().isEmpty() || !crate.canWinPrizes(player))) {
            Messages.no_prizes_found.sendMessage((CommandSender)player, "{crate}", fancyName);
            this.crateManager.removePlayerFromOpeningList(player);
            this.crateManager.removePlayerKeyType(player);
            event.setCancelled(true);
            return;
        }
        if (this.config.getProperty(ConfigKeys.use_new_permission_system).booleanValue()) {
            if (player.hasPermission("crazycrates.deny.open." + fileName)) {
                Messages.no_crate_permission.sendMessage((CommandSender)player, "{crate}", fancyName);
                this.crateManager.removePlayerFromOpeningList(player);
                this.crateManager.removeCrateInUse(player);
                event.setCancelled(true);
                return;
            }
        } else if (!player.hasPermission("crazycrates.open." + fileName)) {
            Messages.no_crate_permission.sendMessage((CommandSender)player, "{crate}", fancyName);
            this.crateManager.removePlayerFromOpeningList(player);
            this.crateManager.removeCrateInUse(player);
            event.setCancelled(true);
            return;
        }
        this.crateManager.addPlayerToOpeningList(player, crate);
        if (crateType != CrateType.cosmic) {
            this.userManager.addOpenedCrate(player.getUniqueId(), fileName);
        }
        YamlConfiguration configuration = event.getConfiguration();
        String broadcastMessage = configuration.getString("Crate.BroadCast", "");
        boolean broadcastToggle = configuration.getBoolean("Crate.OpeningBroadCast", false);
        if (broadcastToggle && crateType != CrateType.cosmic && !event.isSilent() && !broadcastMessage.isBlank()) {
            String builder = Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)broadcastMessage) : broadcastMessage;
            this.server.broadcast(AdvUtils.parse(builder.replaceAll("%crate%", fancyName).replaceAll("%prefix%", this.config.getProperty(ConfigKeys.command_prefix)).replaceAll("%player%", playerName)));
        }
        boolean bl = commandToggle = configuration.contains("Crate.opening-command") && configuration.getBoolean("Crate.opening-command.toggle");
        if (commandToggle && !(commands = configuration.getStringList("Crate.opening-command.commands")).isEmpty()) {
            commands.forEach(line -> {
                String builder = Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)line.replaceAll("%crate%", fileName).replaceAll("%prefix%", this.config.getProperty(ConfigKeys.command_prefix)).replaceAll("%player%", playerName)) : line.replaceAll("%crate%", fileName).replaceAll("%prefix%", this.config.getProperty(ConfigKeys.command_prefix)).replaceAll("%player%", playerName);
                MiscUtils.sendCommand(builder);
            });
        }
        EventManager.logEvent(event.getEventType(), playerName, (CommandSender)player, crate, event.getKeyType(), 1);
    }
}

