/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.player;

import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.events.PlayerReceiveKeyEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.commands.crates.types.BaseCommand;
import com.badbones69.crazycrates.paper.managers.events.EventManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import dev.triumphteam.cmd.core.annotations.Syntax;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CommandTransfer
extends BaseCommand {
    @Command(value="transfer")
    @Permission(value={"crazycrates.transfer"}, def=PermissionDefault.OP)
    @Syntax(value="/crazycrates transfer <crate_name> <player_name> <amount>")
    public void transfer(Player player, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @ArgName(value="player") @Suggestion(value="players") Player target, @ArgName(value="amount") @Suggestion(value="numbers") int amount) {
        if (crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage((CommandSender)player, "{value}", "crate name");
            return;
        }
        Crate crate = this.crateManager.getCrateFromName(crateName);
        if (crate == null || crate.getCrateType() == CrateType.menu) {
            Messages.not_a_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return;
        }
        UUID uuid = player.getUniqueId();
        UUID receiver = target.getUniqueId();
        if (uuid.toString().equalsIgnoreCase(receiver.toString())) {
            Messages.same_player.sendMessage((CommandSender)player);
            return;
        }
        String fancyName = crate.getCrateName();
        String fileName = crate.getFileName();
        if (this.userManager.getVirtualKeys(uuid, fileName) <= amount) {
            Messages.transfer_not_enough_keys.sendMessage((CommandSender)player, "{crate}", fancyName);
            return;
        }
        PlayerReceiveKeyEvent event = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.TRANSFER, amount);
        this.pluginManager.callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.userManager.takeKeys(uuid, fileName, KeyType.virtual_key, amount, false);
        this.userManager.addKeys(receiver, fileName, KeyType.virtual_key, amount);
        String playerName = player.getName();
        Messages.transfer_sent_keys.sendMessage((CommandSender)player, Map.of("{keytype}", KeyType.virtual_key.getFriendlyName(), "{amount}", String.valueOf(amount), "{player}", playerName, "{crate}", fancyName));
        Messages.transfer_received_keys.sendMessage((CommandSender)target, "{player}", playerName);
        EventManager.logEvent(EventType.event_key_transferred, target.getName(), (CommandSender)player, crate, KeyType.virtual_key, amount);
    }
}

