/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types.plugins;

import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.core.api.enums.FileAction;
import libs.com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import libs.com.ryderbelserion.fusion.paper.utils.ItemUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import su.nightexpress.excellentcrates.CratesAPI;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.data.impl.CrateUser;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.nightcore.config.FileConfig;

public class ExcellentCratesMigrator
extends ICrateMigrator {
    private final boolean ignoreCrates;

    public ExcellentCratesMigrator(CommandSender sender, boolean ignoreCrates) {
        super(sender, MigrationType.EXCELLENT_CRATES);
        this.ignoreCrates = ignoreCrates;
    }

    @Override
    public void run() {
        ArrayList<CallSite> failed = new ArrayList<CallSite>();
        ArrayList<CallSite> success = new ArrayList<CallSite>();
        if (this.ignoreCrates) {
            BukkitUserManager userManager = this.plugin.getUserManager();
            for (CrateUser user : CratesAPI.getUserManager().getAllUsers()) {
                String name = user.getName();
                try {
                    UUID uuid = user.getId();
                    user.getKeysMap().forEach((key, amount) -> {
                        if (amount > 0) {
                            YamlConfiguration data = FileKeys.data.getConfiguration();
                            int keys = userManager.getVirtualKeys(uuid, this.crateName);
                            if (!data.contains("Players." + String.valueOf(uuid) + ".Name")) {
                                data.set("Players." + String.valueOf(uuid) + ".Name", (Object)name);
                            }
                            data.set("Players." + String.valueOf(uuid) + "." + key, (Object)Math.max(keys + amount, 0));
                            FileKeys.data.save();
                        }
                    });
                    success.add((CallSite)((Object)("<green>\u2937 " + name)));
                }
                catch (Exception exception) {
                    failed.add((CallSite)((Object)("<red>\u2937 " + name)));
                }
            }
            Messages.successfully_migrated_users.sendMessage(this.sender, Map.of("{succeeded_amount}", String.valueOf(success.size()), "{failed_amount}", String.valueOf(failed.size()), "{type}", this.type.getName(), "{time}", this.time()));
            return;
        }
        File directory = this.getCratesDirectory();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File crateDirectory = CratesAPI.PLUGIN.getDataFolder();
        YamlConfiguration locationData = FileKeys.locations.getConfiguration();
        @NotNull Collection crates = CratesAPI.getCrateManager().getCrates();
        if (crates.isEmpty()) {
            Messages.migration_no_crates_available.sendMessage(this.sender);
            return;
        }
        for (Crate crate : crates) {
            CustomModelData builder;
            String crateName = crate.getFile().getName();
            String strippedName = crateName.replace(".yml", "");
            File crateFile = new File(directory, crateName);
            if (crateFile.exists()) {
                if (MiscUtils.isLogging()) {
                    this.logger.warn("Crate {} already exists in {}.", (Object)crateName, (Object)directory.getName());
                }
                failed.add((CallSite)((Object)("<red>\u2937 " + crateName)));
                return;
            }
            try {
                crateFile.createNewFile();
            }
            catch (IOException exception) {
                if (MiscUtils.isLogging()) {
                    this.logger.warn("Failed to create crate file {} in {}.", new Object[]{crateName, directory.getName(), exception});
                }
                failed.add((CallSite)((Object)("<red>\u2937 " + crateName)));
            }
            PaperCustomFile customFile = (PaperCustomFile)new PaperCustomFile(crateFile.toPath(), new ArrayList<FileAction>()).load();
            YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
            this.set((ConfigurationSection)configuration, "Crate.CrateType", "CSGO");
            ConfigurationSection root = configuration.getConfigurationSection("Crate");
            if (root == null) {
                return;
            }
            FileConfig crateConfig = crate.getConfig();
            List locations = crateConfig.getStringList("Block.Locations");
            if (!locations.isEmpty()) {
                crateConfig.getStringList("Block.Locations").forEach(location -> {
                    Object id = "1";
                    int i = 1;
                    while (locationData.contains("Locations." + i)) {
                        id = "" + (i + 1);
                        ++i;
                    }
                    String[] splitter = location.split(",");
                    String arg5 = splitter[5];
                    String arg0 = splitter[0];
                    String arg1 = splitter[1];
                    String arg2 = splitter[2];
                    locationData.set("Locations." + (String)id + ".Crate", (Object)strippedName);
                    locationData.set("Locations." + (String)id + ".World", (Object)arg5);
                    locationData.set("Locations." + (String)id + ".X", (Object)((int)Double.parseDouble(arg0)));
                    locationData.set("Locations." + (String)id + ".Y", (Object)((int)Double.parseDouble(arg1)));
                    locationData.set("Locations." + (String)id + ".Z", (Object)((int)Double.parseDouble(arg2)));
                    FileKeys.locations.save();
                });
            }
            this.set(root, "Glowing", false);
            String name = crate.getPreviewConfig();
            File file = new File(new File(crateDirectory, "menu"), (String)(name == null ? "default.yml" : name + ".yml"));
            if (file.exists()) {
                YamlConfiguration menuFile = YamlConfiguration.loadConfiguration((File)file);
                String previewName = menuFile.getString("Crate.Name", "<bold><#9af7ff>%crate%</bold>").replace("%crate_name%", "%crate%").replace("%crate%", strippedName);
                ArrayList<String> previewLore = new ArrayList<String>();
                menuFile.getStringList("Crate.Lore").forEach(line -> previewLore.add(line.replaceAll("<l", "<").replaceAll("</l", "</")));
                this.set(root, "Name", AdvUtils.convert(previewName));
                this.set(root, "Lore", AdvUtils.convert(previewLore));
                ConfigurationSection section = menuFile.getConfigurationSection("Crate.Slots");
                if (section != null) {
                    for (String key2 : section.getKeys(false)) {
                        int slot = section.getInt(key2);
                        if (!key2.equalsIgnoreCase(crateName.replace(".yml", ""))) continue;
                        this.set(root, "InGUI", slot > 0);
                        this.set(root, "Slot", slot);
                        break;
                    }
                }
            }
            this.set(root, "Preview.Toggle", true);
            this.set(root, "Preview.ChestLines", 6);
            this.set(root, "Preview.Name", AdvUtils.convert(crate.getName()));
            this.set(root, "Preview.Glass.Toggle", true);
            this.set(root, "Preview.Glass.Name", " ");
            this.set(root, "Preview.Glass.Item", "gray_stained_glass_pane");
            this.set(root, "Preview.Glass.Custom-Model-Data", "");
            this.set(root, "Preview.Glass.Model.Namespace", "");
            this.set(root, "Preview.Glass.Model.Id", "");
            this.set(root, "StartingKeys", 0);
            this.set(root, "RequiredKeys", 0);
            this.set(root, "Max-Mass-Open", 10);
            this.set(root, "OpeningBroadCast", false);
            this.set(root, "BroadCast", "%prefix%<bold><gold>%player%</bold><reset> <gray>is opening a <bold><green>%crate%.</bold>".replace("%crate%", AdvUtils.convert(crate.getName())));
            this.set(root, "opening-command.toggle", false);
            this.set(root, "opening-command.commands", List.of("put your command here."));
            this.set(root, "sound.cycle-sound.toggle", false);
            this.set(root, "sound.cycle-sound.value", "block.note_block_xylophone");
            this.set(root, "sound.cycle-sound.volume", 1.0);
            this.set(root, "sound.cycle-sound.pitch", 1.0);
            this.set(root, "sound.click-sound.toggle", false);
            this.set(root, "sound.click-sound.value", "block.note_block_xylophone");
            this.set(root, "sound.click-sound.volume", 1.0);
            this.set(root, "sound.click-sound.pitch", 1.0);
            this.set(root, "sound.stop-sound.toggle", false);
            this.set(root, "sound.stop-sound.value", "block.note_block_xylophone");
            this.set(root, "sound.stop-sound.volume", 1.0);
            this.set(root, "sound.stop-sound.pitch", 1.0);
            this.set(root, "Prize-Message", List.of("<gray>You have won <red>%reward% <gray>from <red>%crate%."));
            ItemStack crateItem = crate.getItem();
            this.set(root, "Item", crateConfig.getString("Item.Material", "player_head").toLowerCase());
            String itemName = crateConfig.getString("Item.Name", "");
            this.set(root, "Preview-Name", AdvUtils.convert((String)(itemName.isEmpty() ? crateConfig.getString("Name", "%crate%").replace("%crate%", strippedName) : itemName + " Preview")));
            if (crateItem.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA) && (builder = (CustomModelData)crateItem.getData(DataComponentTypes.CUSTOM_MODEL_DATA)) != null) {
                @Unmodifiable List floats = builder.floats();
                this.set(root, "Custom-Model-Data", Float.valueOf(!floats.isEmpty() ? ((Float)floats.getFirst()).floatValue() : -1.0f));
            }
            this.set(root, "Settings.Knockback", crate.isPushbackEnabled());
            this.set(root, "Hologram.Toggle", crate.isHologramEnabled());
            this.set(root, "Hologram.Height", crate.getHologramYOffset());
            this.set(root, "Hologram.Range", 8);
            this.set(root, "Hologram.Update-Interval", -1);
            this.set(root, "Hologram.Color", "transparent");
            ArrayList hologramText = new ArrayList();
            crate.getHologramText().forEach(line -> {
                String filtered = line.replace("%excellentcrates_keys_" + strippedName + "%", "%crazycrates_" + strippedName + "%").replace("%crate%", crate.getName());
                hologramText.add(AdvUtils.convert(filtered));
            });
            this.set(root, "Hologram.Message", hologramText);
            Optional value = crate.getKeys().stream().findFirst();
            if (value.isPresent()) {
                CrateKey key3 = (CrateKey)value.get();
                FileConfig config = key3.getConfig();
                ItemStack itemStack = key3.getItem();
                this.set(root, "PhysicalKey.Data", ItemUtils.toBase64(itemStack));
                this.set(root, "PhysicalKey.Name", AdvUtils.convert(key3.getName().replace("#", "#&")));
                this.set(root, "PhysicalKey.Item", itemStack.getType().getKey().getKey());
                this.set(root, "PhysicalKey.Lore", AdvUtils.convert(key3.getConfig().getStringList("Lore")));
                this.set(root, "PhysicalKey.Glowing", config.contains("Item.Enchants"));
            }
            crate.getRewards().forEach(reward -> {
                ConfigurationSection section;
                Object lore;
                ItemLore itemLore;
                String id = reward.getId();
                ItemStack itemStack = reward.getPreview();
                if (itemStack.hasData((DataComponentType)DataComponentTypes.LORE) && (itemLore = (ItemLore)itemStack.getData(DataComponentTypes.LORE)) != null && !(lore = itemLore.lines()).isEmpty()) {
                    this.set(root, "Prizes." + id + ".DisplayLore", AdvUtils.fromComponent((List<Component>)lore));
                }
                this.set(root, "Prizes." + id + ".DisplayName", AdvUtils.convert(reward.getName().replace("#", "#&")));
                this.set(root, "Prizes." + id + ".Commands", reward.getCommands());
                this.set(root, "Prizes." + id + ".Settings.Broadcast.Toggle", reward.isBroadcast());
                this.set(root, "Prizes." + id + ".Settings.Broadcast.Messages", List.of());
                this.set(root, "Prizes." + id + ".Settings.Broadcast.Permission", "your_permission");
                this.set(root, "Prizes." + id + ".BlackListed-Permissions", new ArrayList(reward.getIgnoredForPermissions()));
                this.set(root, "Prizes." + id + ".Weight", (int)reward.getWeight());
                this.set(root, "Prizes." + id + ".DisplayItem", itemStack.getType().getKey().getKey());
                this.set(root, "Prizes." + id + ".DisplayAmount", itemStack.getAmount());
                ArrayList<CallSite> enchantments = new ArrayList<CallSite>();
                for (Map.Entry entry : itemStack.getEnchantments().entrySet()) {
                    enchantments.add((CallSite)((Object)(((Enchantment)entry.getKey()).getKey().getKey() + ":" + String.valueOf(entry.getValue()))));
                }
                if (!enchantments.isEmpty()) {
                    this.set(root, "Prizes." + id + ".DisplayEnchantments", enchantments);
                }
                if ((section = root.getConfigurationSection("Prizes")) == null) {
                    return;
                }
                ConfigurationSection configurationSection = section.getConfigurationSection(id);
                if (configurationSection == null) {
                    return;
                }
                reward.getItems().forEach(key -> {
                    String base64 = ItemUtils.toBase64(key);
                    if (prizeSection.contains("Items")) {
                        List items = prizeSection.getStringList("Items");
                        items.add("Data: " + base64);
                        this.set(prizeSection, "Items", items);
                    } else {
                        this.set(prizeSection, "Items", List.of("Data: " + base64));
                    }
                });
            });
            this.fileManager.addFile(customFile.save());
            success.add((CallSite)((Object)("<green>\u2937 " + crateName)));
        }
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        ArrayList<String> files = new ArrayList<String>(failedCrates + convertedCrates);
        files.addAll(failed);
        files.addAll(success);
        this.sendMessage(files, convertedCrates, failedCrates);
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

