/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types.deprecation;

import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import libs.com.ryderbelserion.fusion.core.api.enums.FileType;
import libs.com.ryderbelserion.fusion.core.api.interfaces.files.ICustomFile;
import libs.com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class DeprecatedCrateMigrator
extends ICrateMigrator {
    public DeprecatedCrateMigrator(CommandSender sender) {
        super(sender, MigrationType.CRATES_DEPRECATED_ALL);
    }

    @Override
    public void run() {
        Collection<ICustomFile<ICustomFile<?>>> customFiles = this.fileManager.getCustomFiles().values();
        ArrayList failed = new ArrayList();
        ArrayList success = new ArrayList();
        customFiles.forEach(key -> {
            try {
                ConfigurationSection prizes;
                if (key.isStatic() || !key.isLoaded() || key.getFileType() != FileType.PAPER) {
                    return;
                }
                PaperCustomFile customFile = (PaperCustomFile)key;
                YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                ConfigurationSection section = configuration.getConfigurationSection("Crate");
                if (section == null) {
                    return;
                }
                boolean isSave = false;
                if (section.contains("CrateName")) {
                    this.set(section, "Name", section.getString("CrateName", " "));
                    this.set(section, "CrateName", null);
                    isSave = true;
                }
                if (section.contains("Preview-Name")) {
                    this.set(section, "Preview.Name", section.getString("Preview-Name", " "));
                    this.set(section, "Preview-Name", null);
                    isSave = true;
                }
                if (section.contains("Preview.ChestLines")) {
                    this.set(section, "Preview.Rows", section.getInt("Preview.ChestLines"));
                    this.set(section, "Preview.ChestLines", null);
                    isSave = true;
                }
                if (section.contains("Settings.Border.Glass-Border.Toggle")) {
                    this.set(section, "Animation.Glass-Frame.Toggle", section.getBoolean("Settings.Border.Glass-Border.Toggle", true));
                    this.set(section, "Animation.Glass-Frame.Random.Toggle", true);
                    this.set(section, "Animation.Glass-Frame.Random.Items", section.createSection("Animation.Glass-Frame.Random.Items"));
                    this.set(section, "Animation.Glass-Frame.Items", section.createSection("Animation.Glass-Frame.Items"));
                    this.set(section, "Settings.Border.Glass-Border", null);
                    isSave = true;
                }
                if ((prizes = section.getConfigurationSection("Prizes")) != null) {
                    for (String value : prizes.getKeys(false)) {
                        ConfigurationSection prizeSection = prizes.getConfigurationSection(value);
                        if (prizeSection == null) continue;
                        if (prizeSection.contains("Lore")) {
                            this.set(prizeSection, "DisplayLore", prizeSection.getStringList("Lore"));
                            this.set(prizeSection, "Lore", null);
                            isSave = true;
                        }
                        if (!prizeSection.contains("Patterns")) continue;
                        this.set(prizeSection, "DisplayPatterns", prizeSection.getStringList("Patterns"));
                        this.set(prizeSection, "Patterns", null);
                        isSave = true;
                    }
                }
                if (isSave) {
                    customFile.save();
                }
                success.add("<green>\u2937 " + customFile.getFileName());
            }
            catch (Exception exception) {
                failed.add("<red>\u2937 " + key.getFileName());
            }
        });
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        ArrayList<String> files = new ArrayList<String>(failedCrates + convertedCrates);
        files.addAll(failed);
        files.addAll(success);
        this.sendMessage(files, convertedCrates, failedCrates);
        this.fileManager.init((List)new ArrayList());
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

