/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types;

import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import libs.com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class MojangMappedMigratorSingle
extends ICrateMigrator {
    public MojangMappedMigratorSingle(CommandSender sender, String crateName) {
        super(sender, MigrationType.MOJANG_MAPPED_SINGLE, crateName);
    }

    @Override
    public void run() {
        if (this.crateName == null || this.crateName.isEmpty() || this.crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage(this.sender, "{value}", "crate name");
            return;
        }
        PaperCustomFile customFile = this.fileManager.getPaperCustomFile(this.dataPath.resolve("crates").resolve(this.crateName));
        if (customFile == null) {
            Messages.error_migrating.sendMessage(this.sender, Map.of("{file}", this.crateName, "{type}", this.type.getName(), "{reason}", "File was not loaded properly."));
            return;
        }
        if (customFile.isStatic()) {
            Messages.error_migrating.sendMessage(this.sender, Map.of("{file}", this.crateName, "{type}", this.type.getName(), "{reason}", "File requested is not a crate config file."));
            return;
        }
        ArrayList<CallSite> failed = new ArrayList<CallSite>();
        ArrayList<CallSite> success = new ArrayList<CallSite>();
        try {
            this.migrate(customFile, this.crateName);
            success.add((CallSite)((Object)("<green>\u2937 " + this.crateName)));
        }
        catch (Exception exception) {
            failed.add((CallSite)((Object)("<red>\u2937 " + this.crateName)));
        }
        Crate crate = this.crateManager.getCrateFromName(this.crateName);
        this.crateManager.reloadCrate(crate);
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        ArrayList<String> files = new ArrayList<String>(failedCrates + convertedCrates);
        files.addAll(failed);
        files.addAll(success);
        this.sendMessage(files, convertedCrates, failedCrates);
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

