/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates;

import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.commands.crates.types.BaseCommand;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import dev.triumphteam.cmd.core.annotations.Syntax;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CommandClaim
extends BaseCommand {
    @Command(value="claim")
    @Permission(value={"crazycrates.claim"}, def=PermissionDefault.OP)
    @Syntax(value="/crazycrates claim <crate_name>")
    public void add(Player player, @ArgName(value="crate") @Suggestion(value="crates") String crateName) {
        String fileName;
        if (crateName == null || crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage((CommandSender)player, "{value}", "crate name");
            return;
        }
        Crate crate = this.getCrate((CommandSender)player, crateName, false);
        if (crate == null || crate.getCrateType() == CrateType.menu) {
            Messages.not_a_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return;
        }
        UUID uuid = player.getUniqueId();
        if (!this.userManager.hasRespinPrize(uuid, fileName = crate.getFileName())) {
            Messages.crate_prize_respins_empty.sendMessage((CommandSender)player, Map.of("{crate_pretty}", crate.getCrateName(), "{crate}", fileName));
            if (!crate.isCyclePersistRestart()) {
                this.userManager.removeRespinCrate(uuid, fileName, this.userManager.getCrateRespin(uuid, fileName));
            }
            return;
        }
        String prizeName = this.userManager.getRespinPrize(uuid, fileName);
        Prize prize = crate.getPrize(prizeName);
        if (prize == null) {
            Messages.prize_not_found.sendMessage((CommandSender)player, "{prize}", prizeName);
            if (!crate.isCyclePersistRestart()) {
                this.userManager.removeRespinCrate(uuid, fileName, this.userManager.getCrateRespin(uuid, fileName));
            }
            this.userManager.removeRespinPrize(uuid, fileName);
            return;
        }
        PrizeManager.givePrize(player, crate, prize);
        Messages.crate_prize_respins_redeemed.sendMessage((CommandSender)player, Map.of("{crate_pretty}", crate.getCrateName(), "{crate}", fileName, "{prize}", prize.getPrizeName()));
        if (!crate.isCyclePersistRestart()) {
            this.userManager.removeRespinCrate(uuid, fileName, this.userManager.getCrateRespin(uuid, fileName));
        }
        this.userManager.removeRespinPrize(uuid, fileName);
    }
}

