/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates;

import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.commands.crates.types.BaseCommand;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Optional;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import dev.triumphteam.cmd.core.annotations.Syntax;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CommandAddItem
extends BaseCommand {
    @Command(value="additem")
    @Permission(value={"crazycrates.additem"}, def=PermissionDefault.OP)
    @Syntax(value="/crazycrates additem <crate_name> <prize_number> <weight> [tier]")
    public void add(Player player, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @ArgName(value="prize") @Suggestion(value="prizes") String prizeName, @ArgName(value="weight") @Suggestion(value="doubles") double weight, @ArgName(value="tier") @Suggestion(value="tiers") @Optional String tier) {
        if (crateName == null || crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage((CommandSender)player, "{value}", "crate name");
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType().isAir()) {
            Messages.cannot_be_air.sendMessage((CommandSender)player);
            return;
        }
        Crate crate = this.getCrate((CommandSender)player, crateName, false);
        if (crate == null || crate.getCrateType() == CrateType.menu) {
            Messages.not_a_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return;
        }
        String fancyName = crate.getCrateName();
        if (tier != null) {
            crate.addEditorItem(item, prizeName, tier, weight);
            Messages.added_item_with_editor.sendMessage((CommandSender)player, Map.of("{crate}", fancyName, "{prize}", prizeName));
            return;
        }
        crate.addEditorItem(item, prizeName, weight);
        Messages.added_item_with_editor.sendMessage((CommandSender)player, Map.of("{crate}", fancyName, "{prize}", prizeName));
    }
}

