/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.events.PlayerReceiveKeyEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.InventoryManager;
import com.badbones69.crazycrates.paper.managers.events.EventManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import dev.triumphteam.cmd.core.annotations.Command;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.files.FileManager;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

@Command(value="crazycrates", alias={"crates", "crate", "cc"})
public abstract class BaseCommand {
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    protected final Path path = this.plugin.getDataPath();
    protected final Server server = this.plugin.getServer();
    protected final PluginManager pluginManager = this.server.getPluginManager();
    protected final ComponentLogger logger = this.plugin.getComponentLogger();
    protected final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    protected final BukkitUserManager userManager = this.plugin.getUserManager();
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    protected final FileManager fileManager = this.plugin.getFileManager();
    protected final SettingsManager config = ConfigManager.getConfig();

    protected void addKey(@NotNull CommandSender sender, @NotNull Player player, @NotNull Crate crate, @NotNull KeyType type, int amount, boolean isSilent, boolean isGiveAll) {
        this.addKey(sender, player, null, crate, type, amount, isSilent, isGiveAll);
    }

    protected void addKey(@NotNull CommandSender sender, @NotNull Player player, @NotNull Crate crate, @NotNull KeyType type, int amount, boolean isSilent) {
        this.addKey(sender, player, null, crate, type, amount, isSilent, false);
    }

    protected void addKey(@NotNull CommandSender sender, @Nullable OfflinePlayer player, @NotNull Crate crate, @NotNull KeyType keyType, int amount, boolean isSilent) {
        this.addKey(sender, null, player, crate, keyType, amount, isSilent, false);
    }

    protected void takeKey(@NotNull CommandSender sender, @NotNull Player player, @NotNull Crate crate, @NotNull KeyType keyType, int amount) {
        this.takeKey(sender, player, null, crate, keyType, amount);
    }

    protected void takeKey(@NotNull CommandSender sender, @Nullable OfflinePlayer player, @NotNull Crate crate, @NotNull KeyType keyType, int amount) {
        this.takeKey(sender, null, player, crate, keyType, amount);
    }

    @NotNull
    protected final KeyType getKeyType(@NotNull String type) {
        if (type.isEmpty()) {
            return KeyType.virtual_key;
        }
        KeyType keyType = KeyType.getFromName(type);
        if (keyType == null || keyType == KeyType.free_key) {
            return KeyType.virtual_key;
        }
        return keyType;
    }

    protected final Crate getCrate(@NotNull CommandSender sender, @NotNull String name, boolean ignoreChecks) {
        if (name.isEmpty()) {
            return null;
        }
        Crate crate = this.crateManager.getCrateFromName(name);
        if (ignoreChecks && (crate == null || crate.getCrateType() == CrateType.menu)) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", name);
            return null;
        }
        return crate;
    }

    @ApiStatus.Internal
    private void takeKey(@NotNull CommandSender sender, @Nullable Player player, @Nullable OfflinePlayer offlinePlayer, @NotNull Crate crate, @NotNull KeyType type, int amount) {
        String fileName = crate.getFileName();
        if (player != null) {
            UUID uuid = player.getUniqueId();
            String name = player.getName();
            int totalKeys = this.userManager.getTotalKeys(uuid, fileName);
            if (totalKeys < 1) {
                if (MiscUtils.isLogging()) {
                    this.logger.warn("The player {} does not have enough keys to take.", (Object)name);
                }
                Messages.cannot_take_keys.sendMessage(sender, "{player}", name);
                return;
            }
            if (totalKeys < amount) {
                amount = type == KeyType.physical_key ? this.userManager.getPhysicalKeys(uuid, fileName) : this.userManager.getVirtualKeys(uuid, fileName);
            }
            this.userManager.takeKeys(uuid, fileName, type, amount, false);
            int finalAmount = amount;
            Messages.take_player_keys.sendMessage(sender, Map.of("{keytype}", type.getFriendlyName(), "{amount}", String.valueOf(finalAmount), "{player}", name, "{key}", crate.getKeyName()));
            EventManager.logEvent(EventType.event_key_removed, name, sender, crate, type, amount);
            return;
        }
        if (offlinePlayer != null) {
            String name = offlinePlayer.getName();
            Messages.take_offline_player_keys.sendMessage(sender, Map.of("{amount}", String.valueOf(amount), "{keytype}", type.getFriendlyName(), "{key}", crate.getKeyName(), "{player}", name == null ? "N/A" : name));
            this.userManager.takeOfflineKeys(offlinePlayer.getUniqueId(), fileName, type, amount);
            EventManager.logEvent(EventType.event_key_removed, name == null ? "N/A" : name, sender, crate, type, amount);
        }
    }

    @ApiStatus.Internal
    private void addKey(@NotNull CommandSender sender, @Nullable Player player, @Nullable OfflinePlayer offlinePlayer, @NotNull Crate crate, @NotNull KeyType type, int amount, boolean isSilent, boolean isGiveAll) {
        String fileName = crate.getFileName();
        if (player != null) {
            if (!isGiveAll) {
                PlayerReceiveKeyEvent event = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.GIVE_COMMAND, amount);
                this.pluginManager.callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            UUID uuid = player.getUniqueId();
            String name = player.getName();
            this.userManager.addKeys(uuid, fileName, crate.getCrateType() == CrateType.crate_on_the_go ? KeyType.physical_key : type, amount);
            Map<String, String> placeholders = Map.of("{keytype}", type.getFriendlyName(), "{amount}", String.valueOf(amount), "{player}", name, "{key}", crate.getKeyName());
            boolean fullMessage = this.config.getProperty(ConfigKeys.notify_player_when_inventory_full);
            boolean inventoryCheck = this.config.getProperty(ConfigKeys.give_virtual_keys_when_inventory_full);
            EventManager.logEvent(EventType.event_key_given, name, sender, crate, type, amount);
            if (!isGiveAll) {
                Messages.gave_a_player_keys.sendMessage(sender, placeholders);
            }
            if (isSilent) {
                return;
            }
            if (!inventoryCheck || !fullMessage && !MiscUtils.isInventoryFull(player) && player.isOnline()) {
                Messages.obtaining_keys.sendMessage((CommandSender)player, placeholders);
            }
            return;
        }
        if (offlinePlayer != null) {
            PlayerReceiveKeyEvent event = new PlayerReceiveKeyEvent(offlinePlayer, crate, PlayerReceiveKeyEvent.KeyReceiveReason.GIVE_COMMAND, amount);
            this.pluginManager.callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (!this.userManager.addOfflineKeys(offlinePlayer.getUniqueId(), fileName, type, amount)) {
                Messages.internal_error.sendMessage(sender);
            } else {
                String name = offlinePlayer.getName();
                Map<String, String> placeholders = Map.of("{keytype}", type.getFriendlyName(), "{amount}", String.valueOf(amount), "{key}", crate.getKeyName(), "{player}", name == null ? "N/A" : name);
                Messages.given_offline_player_keys.sendMessage(sender, placeholders);
                EventManager.logEvent(EventType.event_key_given, name == null ? "N/A" : name, sender, crate, type, amount);
            }
        }
    }
}

