/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.objects;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.List;
import libs.com.ryderbelserion.fusion.core.api.utils.StringUtils;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tier {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    private final LegacyItemBuilder item;
    private final String name;
    private final List<String> lore;
    private final String coloredName;
    private final double weight;
    private final int slot;

    public Tier(@NotNull String tier, @NotNull ConfigurationSection section) {
        this.name = tier;
        this.coloredName = section.getString("Name", "");
        this.lore = section.getStringList("Lore");
        this.item = (LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder(this.plugin).withType(section.getString("Item", "chest").toLowerCase())).setHidingItemFlags(section.getBoolean("HideItemFlags", false))).setCustomModelData(section.getString("Custom-Model-Data", ""))).setItemModel(section.getString("Model.Namespace", ""), section.getString("Model.Id", ""));
        this.weight = section.getDouble("Weight", -1.0);
        this.slot = section.getInt("Slot");
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getColoredName() {
        return this.coloredName;
    }

    @NotNull
    public final LegacyItemBuilder getItem() {
        return this.item;
    }

    public final double getWeight() {
        if (this.weight == -1.0 && MiscUtils.isLogging()) {
            this.logger.warn("Cannot fetch the weight as the option is not present for this tier: {}", (Object)this.name);
        }
        return this.weight;
    }

    public final int getSlot() {
        return this.slot;
    }

    @NotNull
    public final ItemStack getTierItem(@Nullable Player target, @NotNull Crate crate) {
        if (target != null) {
            this.item.setPlayer(target);
        }
        return ((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)this.item.setDisplayName(this.coloredName)).setDisplayLore(this.lore)).addLorePlaceholder("%chance%", StringUtils.format(crate.getTierChance(this.getWeight())))).setPersistentString(ItemKeys.crate_tier.getNamespacedKey(), this.name)).asItemStack();
    }
}

