/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.builders.gui;

import com.badbones69.crazycrates.core.config.beans.inventories.ItemPlacement;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.builders.gui.InventoryBuilder;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.PaginatedBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.Gui;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.types.PaginatedGui;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicInventoryBuilder
extends InventoryBuilder {
    private final PaginatedGui gui;
    private final Crate crate;

    public DynamicInventoryBuilder(@NotNull Player player, @Nullable Crate crate, @NotNull String title, int rows) {
        super(player);
        this.gui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated(this.plugin).setTitle(title)).setRows(rows)).disableInteractions()).create();
        this.crate = crate;
    }

    public DynamicInventoryBuilder(@NotNull Player player, @NotNull String title, int rows) {
        this(player, null, title, rows);
    }

    public void open() {
        this.open(null);
    }

    public void open(@Nullable Consumer<DynamicInventoryBuilder> consumer) {
        if (consumer != null) {
            consumer.accept(this);
        }
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Crate getCrate() {
        return this.crate;
    }

    @NotNull
    public final PaginatedGui getGui() {
        return this.gui;
    }

    public void addBackButton(boolean isPreview) {
        ItemPlacement backButtonPlacement = this.config.getProperty(ConfigKeys.back_button_placement);
        int column = backButtonPlacement.getColumn();
        int row = backButtonPlacement.getRow();
        int rows = this.gui.getRows();
        int safeRow = Math.min(row == -1 ? rows : row, rows);
        if (this.gui.getCurrentPageNumber() <= 1) {
            this.setFillerItem(safeRow, column, isPreview);
            return;
        }
        this.gui.setItem(safeRow, column, new GuiItem(this.inventoryManager.getBackButton(this.player, this.gui), event -> {
            event.setCancelled(true);
            this.gui.previous();
            int page = this.gui.getCurrentPageNumber();
            if (page <= 1) {
                this.setFillerItem(safeRow, column, isPreview);
            } else {
                this.addBackButton(isPreview);
            }
            if (page < this.gui.getMaxPages()) {
                this.addNextButton(isPreview);
            }
        }));
    }

    public void addNextButton(boolean isPreview) {
        if (this.gui.getCurrentPageNumber() >= this.gui.getMaxPages()) {
            return;
        }
        ItemPlacement nextButtonPlacement = this.config.getProperty(ConfigKeys.next_button_placement);
        int column = nextButtonPlacement.getColumn();
        int row = nextButtonPlacement.getRow();
        int rows = this.gui.getRows();
        int safeRow = Math.min(row == -1 ? rows : row, rows);
        this.gui.setItem(safeRow, column, new GuiItem(this.inventoryManager.getNextButton(this.player, this.gui), event -> {
            event.setCancelled(true);
            this.gui.next();
            int page = this.gui.getCurrentPageNumber();
            if (page >= this.gui.getMaxPages()) {
                this.setFillerItem(safeRow, column, isPreview);
            } else {
                this.addNextButton(isPreview);
            }
            if (page <= 1) {
                if (this.crate != null && this.crate.isBorderToggle()) {
                    this.gui.setItem(safeRow, column, this.crate.getBorderItem().asGuiItem());
                } else if (!isPreview) {
                    this.gui.removeItem(safeRow, column);
                    this.gui.setItem(safeRow, column, new GuiItem((ItemType)ItemType.BLACK_STAINED_GLASS_PANE));
                }
            } else {
                this.addBackButton(isPreview);
            }
        }));
    }

    private void setFillerItem(int row, int column, boolean isPreview) {
        if (this.crate != null && this.crate.isBorderToggle()) {
            this.gui.setItem(row, column, this.crate.getBorderItem().asGuiItem());
        } else if (!isPreview) {
            this.gui.removeItem(row, column);
            this.gui.setItem(row, column, new GuiItem((ItemType)ItemType.BLACK_STAINED_GLASS_PANE));
        }
    }
}

