/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import java.math.BigDecimal;
import org.jetbrains.annotations.Nullable;

public interface ValueRange<T> {
    @Nullable
    public BigDecimal getMinValue();

    @Nullable
    public BigDecimal getMaxValue();

    @Nullable
    public T getMinInOwnType();

    @Nullable
    public T getMaxInOwnType();

    public boolean supportsDecimals();

    public boolean hasInfinityAndNaN();

    default public boolean supportsAllValuesOf(ValueRange<?> other) {
        return this.isEqualOrSupersetOf(other) && (this.hasInfinityAndNaN() || !other.hasInfinityAndNaN());
    }

    default public boolean isEqualOrSupersetOf(ValueRange<?> other) {
        if (this.getMinValue() != null && (other.getMinValue() == null || this.getMinValue().compareTo(other.getMinValue()) > 0)) {
            return false;
        }
        return this.getMaxValue() == null || other.getMaxValue() != null && this.getMaxValue().compareTo(other.getMaxValue()) >= 0;
    }
}

