/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import ch.jalu.typeresolver.numbers.NumberType;
import ch.jalu.typeresolver.numbers.RangeComparisonHelper;
import ch.jalu.typeresolver.numbers.StandardValueRange;
import ch.jalu.typeresolver.numbers.ValueRange;
import ch.jalu.typeresolver.numbers.ValueRangeComparison;
import ch.jalu.typeresolver.primitives.PrimitiveType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public enum StandardNumberType implements NumberType
{
    BYTE(Byte.class, StandardValueRange.BYTE){

        @Override
        public Number convertUnsafe(Number number) {
            return number.byteValue();
        }
    }
    ,
    SHORT(Short.class, StandardValueRange.SHORT){

        @Override
        public Number convertUnsafe(Number number) {
            return number.shortValue();
        }
    }
    ,
    INTEGER(Integer.class, StandardValueRange.INTEGER){

        @Override
        public Number convertUnsafe(Number number) {
            return number.intValue();
        }
    }
    ,
    LONG(Long.class, StandardValueRange.LONG){

        @Override
        public Number convertUnsafe(Number number) {
            return number.longValue();
        }
    }
    ,
    FLOAT(Float.class, StandardValueRange.FLOAT){

        @Override
        public Number convertUnsafe(Number number) {
            return Float.valueOf(number.floatValue());
        }
    }
    ,
    DOUBLE(Double.class, StandardValueRange.DOUBLE){

        @Override
        public Number convertUnsafe(Number number) {
            return number.doubleValue();
        }
    }
    ,
    BIG_INTEGER(BigInteger.class, StandardValueRange.BIG_INTEGER){

        @Override
        public Number convertUnsafe(Number number) {
            return StandardNumberType.convertToBigInteger(number, StandardValueRange.findRangeOrThrow(number));
        }
    }
    ,
    BIG_DECIMAL(BigDecimal.class, StandardValueRange.BIG_DECIMAL){

        @Override
        public Number convertUnsafe(Number number) {
            return StandardNumberType.convertToBigDecimal(number, StandardValueRange.findRangeOrThrow(number));
        }
    };

    public static final NumberType<Byte> TYPE_BYTE;
    public static final NumberType<Short> TYPE_SHORT;
    public static final NumberType<Integer> TYPE_INTEGER;
    public static final NumberType<Long> TYPE_LONG;
    public static final NumberType<Float> TYPE_FLOAT;
    public static final NumberType<Double> TYPE_DOUBLE;
    public static final NumberType<BigInteger> TYPE_BIG_INTEGER;
    public static final NumberType<BigDecimal> TYPE_BIG_DECIMAL;
    private static final Map<Class<?>, StandardNumberType> typeToEnumEntry;
    private final Class<? extends Number> type;
    private final StandardValueRange range;

    private <T extends Number> StandardNumberType(Class<T> type, StandardValueRange range) {
        this.type = type;
        this.range = range;
    }

    public Class<? extends Number> getType() {
        return this.type;
    }

    public ValueRange<?> getValueRange() {
        return this.range;
    }

    public Optional<Number> convertIfNoLossOfMagnitude(Number number) {
        if (this.compareToValueRange(number) == ValueRangeComparison.WITHIN_RANGE) {
            return Optional.of(this.convertUnsafe(number));
        }
        return Optional.empty();
    }

    public Number convertToBounds(Number numberToConvert) {
        ValueRangeComparison rangeComparison = this.compareToValueRange(numberToConvert);
        if (rangeComparison == ValueRangeComparison.WITHIN_RANGE) {
            return this.convertUnsafe(numberToConvert);
        }
        return this.getFallbackForValueOutOfRange(rangeComparison);
    }

    public abstract Number convertUnsafe(Number var1);

    @Override
    public ValueRangeComparison compareToValueRange(Number number) {
        StandardValueRange numberRange = StandardValueRange.findRangeOrThrow(number);
        if (this.range.supportsAllValuesOf(numberRange)) {
            return ValueRangeComparison.WITHIN_RANGE;
        }
        switch (this) {
            case BYTE: 
            case SHORT: 
            case INTEGER: {
                return this.compareToRangeOfIntOrSmaller(number, numberRange);
            }
            case LONG: {
                return StandardNumberType.compareToLongRange(number, numberRange);
            }
            case FLOAT: 
            case DOUBLE: {
                return this.compareToFloatOrDoubleRange(number, numberRange);
            }
            case BIG_INTEGER: 
            case BIG_DECIMAL: {
                return ValueRangeComparison.getErrorForNonFiniteValue(number).orElse(ValueRangeComparison.WITHIN_RANGE);
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    @Nullable
    public static StandardNumberType fromClass(Class<?> clazz) {
        return typeToEnumEntry.get(PrimitiveType.toReferenceType(clazz));
    }

    @Nullable
    public static <T extends Number> NumberType<T> fromNumberClass(@Nullable Class<T> clazz) {
        return StandardNumberType.fromClass(clazz);
    }

    public static Stream<NumberType<? extends Number>> streamThroughAll() {
        return Arrays.stream(StandardNumberType.values());
    }

    public static Stream<NumberType<? extends Number>> streamThroughPrimitiveTypes() {
        return Stream.of(TYPE_BYTE, TYPE_SHORT, TYPE_INTEGER, TYPE_LONG, TYPE_FLOAT, TYPE_DOUBLE);
    }

    public String toString() {
        return "StandardNumberType[" + this.name() + "]";
    }

    private Number getFallbackForValueOutOfRange(ValueRangeComparison comparison) {
        if (this == BIG_DECIMAL) {
            return BigDecimal.ZERO;
        }
        if (this == BIG_INTEGER) {
            return BigInteger.ZERO;
        }
        switch (comparison) {
            case BELOW_MINIMUM: 
            case UNSUPPORTED_NEGATIVE_INFINITY: {
                return this.range.getMinInOwnType();
            }
            case ABOVE_MAXIMUM: 
            case UNSUPPORTED_POSITIVE_INFINITY: {
                return this.range.getMaxInOwnType();
            }
            case UNSUPPORTED_NAN: {
                return this.convertUnsafe(0);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)comparison));
    }

    private static BigDecimal convertToBigDecimal(Number number, StandardValueRange valueRange) {
        switch (valueRange) {
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                long longValue = number.longValue();
                return BigDecimal.valueOf(longValue);
            }
            case FLOAT: 
            case DOUBLE: {
                double dblValue = number.doubleValue();
                return ValueRangeComparison.getErrorForNonFiniteValue(dblValue).map(error -> BigDecimal.ZERO).orElseGet(() -> BigDecimal.valueOf(dblValue));
            }
            case BIG_INTEGER: {
                return new BigDecimal((BigInteger)number);
            }
            case BIG_DECIMAL: {
                return (BigDecimal)number;
            }
        }
        throw new IllegalStateException("Unexpected value: " + valueRange);
    }

    private static BigInteger convertToBigInteger(Number number, StandardValueRange range) {
        switch (range) {
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                long longValue = number.longValue();
                return BigInteger.valueOf(longValue);
            }
            case FLOAT: 
            case DOUBLE: {
                double dblValue = number.doubleValue();
                return ValueRangeComparison.getErrorForNonFiniteValue(dblValue).map(error -> BigInteger.ZERO).orElseGet(() -> BigDecimal.valueOf(dblValue).toBigInteger());
            }
            case BIG_INTEGER: {
                return (BigInteger)number;
            }
            case BIG_DECIMAL: {
                return ((BigDecimal)number).toBigInteger();
            }
        }
        throw new IllegalStateException("Unexpected value: " + range);
    }

    private ValueRangeComparison compareToRangeOfIntOrSmaller(Number number, StandardValueRange numberRange) {
        StandardValueRange narrowedRange;
        if (StandardValueRange.LONG.supportsAllValuesOf(numberRange)) {
            narrowedRange = numberRange;
        } else {
            ValueRangeComparison longRangeComparison = StandardNumberType.compareToLongRange(number, numberRange);
            if (longRangeComparison != ValueRangeComparison.WITHIN_RANGE) {
                return longRangeComparison;
            }
            narrowedRange = StandardValueRange.LONG;
        }
        switch (narrowedRange) {
            case SHORT: 
            case INTEGER: {
                return RangeComparisonHelper.compareToRange(number.intValue(), this.getMinAsIntOrThrow(), this.getMaxAsIntOrThrow());
            }
            case LONG: {
                return RangeComparisonHelper.compareToRange(number.longValue(), (long)this.getMinAsIntOrThrow(), (long)this.getMaxAsIntOrThrow());
            }
        }
        throw new IllegalStateException("Unexpected value: " + narrowedRange);
    }

    private static ValueRangeComparison compareToLongRange(Number number, StandardValueRange range) {
        switch (range) {
            case FLOAT: 
            case DOUBLE: {
                return RangeComparisonHelper.compareToLongRange(number.doubleValue());
            }
            case BIG_INTEGER: 
            case BIG_DECIMAL: {
                BigDecimal value = StandardNumberType.convertToBigDecimal(number, range);
                return RangeComparisonHelper.compareToRange(value, StandardNumberType.LONG.range.getMinValue(), StandardNumberType.LONG.range.getMaxValue());
            }
        }
        throw new IllegalStateException("Unexpected value: " + range);
    }

    private ValueRangeComparison compareToFloatOrDoubleRange(Number number, StandardValueRange range) {
        if (this == FLOAT && range == StandardValueRange.DOUBLE) {
            double doubleValue = number.doubleValue();
            return Double.isInfinite(doubleValue) ? ValueRangeComparison.WITHIN_RANGE : RangeComparisonHelper.compareToRange(doubleValue, -3.4028234663852886E38, 3.4028234663852886E38);
        }
        switch (range) {
            case BIG_INTEGER: 
            case BIG_DECIMAL: {
                BigDecimal bigDecimal = StandardNumberType.convertToBigDecimal(number, range);
                return RangeComparisonHelper.compareToRange(bigDecimal, this.range.getMinValue(), this.range.getMaxValue());
            }
        }
        throw new IllegalStateException("Unexpected value: " + range);
    }

    private int getMinAsIntOrThrow() {
        switch (this) {
            case BYTE: {
                return -128;
            }
            case SHORT: {
                return Short.MIN_VALUE;
            }
            case INTEGER: {
                return Integer.MIN_VALUE;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    private int getMaxAsIntOrThrow() {
        switch (this) {
            case BYTE: {
                return 127;
            }
            case SHORT: {
                return Short.MAX_VALUE;
            }
            case INTEGER: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    private static Map<Class<?>, StandardNumberType> initReferenceTypeToStandardNumberTypeMap() {
        HashMap<Class, StandardNumberType> referenceTypeToNumberType = new HashMap<Class, StandardNumberType>();
        referenceTypeToNumberType.put(Byte.class, BYTE);
        referenceTypeToNumberType.put(Short.class, SHORT);
        referenceTypeToNumberType.put(Integer.class, INTEGER);
        referenceTypeToNumberType.put(Long.class, LONG);
        referenceTypeToNumberType.put(Float.class, FLOAT);
        referenceTypeToNumberType.put(Double.class, DOUBLE);
        referenceTypeToNumberType.put(BigInteger.class, BIG_INTEGER);
        referenceTypeToNumberType.put(BigDecimal.class, BIG_DECIMAL);
        return Collections.unmodifiableMap(referenceTypeToNumberType);
    }

    static {
        TYPE_BYTE = BYTE;
        TYPE_SHORT = SHORT;
        TYPE_INTEGER = INTEGER;
        TYPE_LONG = LONG;
        TYPE_FLOAT = FLOAT;
        TYPE_DOUBLE = DOUBLE;
        TYPE_BIG_INTEGER = BIG_INTEGER;
        TYPE_BIG_DECIMAL = BIG_DECIMAL;
        typeToEnumEntry = StandardNumberType.initReferenceTypeToStandardNumberTypeMap();
    }
}

