/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.internal;

import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PathUtils {
    public static final String OPTIONAL_SPECIFIER = "$opt";

    private PathUtils() {
    }

    @NotNull
    public static String concat(@NotNull String parent, @NotNull String child) {
        if (parent.isEmpty()) {
            return child;
        }
        return parent + "." + child;
    }

    @NotNull
    public static String concatSpecifierAware(@NotNull String parent, @NotNull String child) {
        if (PathUtils.isSpecifierSuffix(child)) {
            return parent.concat(child);
        }
        return PathUtils.concat(parent, child);
    }

    @NotNull
    public static String pathSpecifierForIndex(int index) {
        return "[" + index + "]";
    }

    @NotNull
    public static String pathSpecifierForMapKey(@NotNull Map.Entry<?, ?> entry) {
        return "[k=" + String.valueOf(entry.getKey()) + "]";
    }

    @NotNull
    public static String pathSpecifierForMapKey(@NotNull String key) {
        return "[k=" + key + "]";
    }

    public static boolean isSpecifierSuffix(@NotNull String path) {
        if (!path.isEmpty()) {
            char firstChar = path.charAt(0);
            return firstChar == '[' || firstChar == '$';
        }
        return false;
    }
}

