/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme;

import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerImpl;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.configurationdata.ConfigurationDataBuilder;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.migration.PlainMigrationService;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.resource.YamlFileResource;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import ch.jalu.configme.utils.FileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettingsManagerBuilder {
    private final PropertyResource resource;
    private ConfigurationData configurationData;
    @Nullable
    private MigrationService migrationService;

    private SettingsManagerBuilder(@NotNull PropertyResource resource) {
        this.resource = resource;
    }

    @NotNull
    public static SettingsManagerBuilder withYamlFile(@NotNull Path file) {
        return SettingsManagerBuilder.withYamlFile(file, YamlFileResourceOptions.builder().build());
    }

    @NotNull
    public static SettingsManagerBuilder withYamlFile(@NotNull File file) {
        return SettingsManagerBuilder.withYamlFile(file.toPath());
    }

    @NotNull
    public static SettingsManagerBuilder withYamlFile(@NotNull Path path, @NotNull YamlFileResourceOptions resourceOptions) {
        FileUtils.createFileIfNotExists(path);
        return new SettingsManagerBuilder(new YamlFileResource(path, resourceOptions));
    }

    @NotNull
    public static SettingsManagerBuilder withYamlFile(@NotNull File file, @NotNull YamlFileResourceOptions resourceOptions) {
        return SettingsManagerBuilder.withYamlFile(file.toPath(), resourceOptions);
    }

    @NotNull
    public static SettingsManagerBuilder withResource(@NotNull PropertyResource resource) {
        return new SettingsManagerBuilder(resource);
    }

    @SafeVarargs
    @NotNull
    public final SettingsManagerBuilder configurationData(Class<? extends SettingsHolder> ... classes) {
        this.configurationData = ConfigurationDataBuilder.createConfiguration(classes);
        return this;
    }

    @NotNull
    public SettingsManagerBuilder configurationData(@NotNull ConfigurationData configurationData) {
        this.configurationData = configurationData;
        return this;
    }

    @NotNull
    public SettingsManagerBuilder migrationService(@Nullable MigrationService migrationService) {
        this.migrationService = migrationService;
        return this;
    }

    @NotNull
    public SettingsManagerBuilder useDefaultMigrationService() {
        this.migrationService = new PlainMigrationService();
        return this;
    }

    @NotNull
    public SettingsManager create() {
        Objects.requireNonNull(this.resource, "resource");
        Objects.requireNonNull(this.configurationData, "configurationData");
        return new SettingsManagerImpl(this.resource, this.configurationData, this.migrationService);
    }
}

