/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.utils;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Base64;
import libs.com.ryderbelserion.fusion.api.FusionApi;
import libs.com.ryderbelserion.fusion.api.interfaces.ILogger;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    private static final FusionApi api = FusionApi.Provider.get();
    private static final ILogger logger = api.getLogger();
    private static final boolean isVerbose = api.isVerbose();

    @NotNull
    public static RegistryAccess getRegistryAccess() {
        return RegistryAccess.registryAccess();
    }

    @Nullable
    public static ItemType getItemType(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching item types.", (Object)value);
            }
            return null;
        }
        @Nullable ItemType key = (ItemType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.ITEM).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid item type.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static Sound getSound(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the sound.", (Object)value);
            }
            return null;
        }
        @Nullable Sound key = (Sound)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.SOUND_EVENT).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid sound.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static Enchantment getEnchantment(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the enchantment.", (Object)value);
            }
            return null;
        }
        @Nullable Enchantment key = (Enchantment)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid enchantment.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static TrimPattern getTrimPattern(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the trim pattern.", (Object)value);
            }
            return null;
        }
        @Nullable TrimPattern key = (TrimPattern)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.TRIM_PATTERN).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid trim pattern.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static TrimMaterial getTrimMaterial(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the trim material.", (Object)value);
            }
            return null;
        }
        @Nullable TrimMaterial key = (TrimMaterial)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.TRIM_MATERIAL).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid trim material.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static PotionType getPotionType(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the potion.", (Object)value);
            }
            return null;
        }
        @Nullable PotionType key = (PotionType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.POTION).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid potion.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static PotionEffectType getPotionEffect(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the potion effect.", (Object)value);
            }
            return null;
        }
        @Nullable PotionEffectType key = (PotionEffectType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.MOB_EFFECT).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid potion effect.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static Particle getParticleType(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the particle.", (Object)value);
            }
            return null;
        }
        @Nullable Particle key = (Particle)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.PARTICLE_TYPE).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid particle.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static PatternType getPatternType(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching banner pattern types!", (Object)value);
            }
            return null;
        }
        @Nullable PatternType key = (PatternType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.BANNER_PATTERN).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid banner pattern.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static EntityType getEntity(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the entity.", (Object)value);
            }
            return null;
        }
        @Nullable EntityType key = (EntityType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.ENTITY_TYPE).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid entity.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @Nullable
    public static Attribute getAttribute(@NotNull String value) {
        if (value.isEmpty()) {
            if (isVerbose) {
                logger.severe("{} cannot be blank when fetching the attribute.", (Object)value);
            }
            return null;
        }
        @Nullable Attribute key = (Attribute)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.ATTRIBUTE).get(ItemUtils.getKey(value));
        if (key == null) {
            if (isVerbose) {
                logger.severe("{} is not a valid attribute.", (Object)value);
            }
            return null;
        }
        return key;
    }

    @NotNull
    private static NamespacedKey getKey(@NotNull String value) {
        return NamespacedKey.minecraft((String)value);
    }

    public static byte[] toBytes(@NotNull ItemStack itemStack) {
        return itemStack.serializeAsBytes();
    }

    @NotNull
    public static ItemStack fromBytes(byte @NotNull [] bytes) {
        return ItemStack.deserializeBytes((byte[])bytes);
    }

    public static String toBase64(@NotNull ItemStack itemStack) {
        return Base64.getEncoder().encodeToString(itemStack.serializeAsBytes());
    }

    @NotNull
    public static ItemStack fromBase64(@NotNull String base64) {
        return ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(base64));
    }
}

