/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.api.utils.FileUtils;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.api.LoggerImpl;
import libs.com.ryderbelserion.fusion.paper.files.LegacyCustomFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LegacyFileManager {
    private final FusionCore api = FusionCore.FusionProvider.get();
    private final LoggerImpl logger = this.api.getLogger();
    private final File dataFolder = this.api.getDataFolder().toFile();
    private final boolean isVerbose = this.api.isVerbose();
    private final Map<String, LegacyCustomFile> files = new HashMap<String, LegacyCustomFile>();
    private final Map<String, FileType> folders = new HashMap<String, FileType>();

    public LegacyFileManager addFolder(@NotNull String folder, @NotNull FileType fileType) {
        if (folder.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot add the folder as the folder is empty.");
            }
            return this;
        }
        if (!this.folders.containsKey(folder)) {
            this.folders.put(folder, fileType);
        }
        File directory = new File(this.dataFolder, folder);
        FileUtils.extract(directory.getName(), this.dataFolder.toPath(), false);
        File[] contents = directory.listFiles();
        if (contents == null) {
            return this;
        }
        String extension = fileType.getExtension();
        for (File file : contents) {
            if (file.isDirectory()) {
                String[] files = file.list();
                if (files == null) continue;
                for (String fileName : files) {
                    if (!fileName.endsWith(extension)) continue;
                    this.addFile(fileName, folder + File.separator + file.getName(), true, fileType);
                }
                continue;
            }
            String fileName = file.getName();
            if (!fileName.endsWith(extension)) continue;
            this.addFile(fileName, folder, true, fileType);
        }
        return this;
    }

    public LegacyFileManager addFile(@NotNull LegacyCustomFile customFile) {
        this.files.put(customFile.getEffectiveName(), customFile);
        return this;
    }

    public LegacyFileManager addFile(@NotNull String fileName) {
        FileType type = FileType.NONE;
        if (fileName.endsWith(".yml")) {
            type = FileType.YAML;
        } else if (fileName.endsWith(".json")) {
            type = FileType.JSON;
        } else if (fileName.endsWith(".nbt")) {
            type = FileType.NBT;
        }
        return this.addFile(fileName, null, false, type);
    }

    public LegacyFileManager addFile(@NotNull String fileName, @NotNull FileType fileType) {
        return this.addFile(fileName, null, false, fileType);
    }

    public LegacyFileManager addFile(@NotNull String fileName, @Nullable String folder, boolean isDynamic, @NotNull FileType fileType) {
        if (fileName.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot add the file as the file is null or empty.");
            }
            return this;
        }
        String extension = fileType.getExtension();
        String strippedName = this.strip(fileName, extension);
        Object resourcePath = folder != null ? folder + File.separator + fileName : fileName;
        File file = new File(this.dataFolder, (String)resourcePath);
        if (!file.exists()) {
            if (this.isVerbose) {
                this.logger.warn("Successfully extracted file {} to {}", fileName, file.getPath());
            }
            this.saveResource((String)resourcePath);
        }
        switch (fileType) {
            case NBT: {
                if (this.files.containsKey(strippedName)) {
                    throw new FusionException("The file '" + strippedName + "' already exists.");
                }
                this.files.put(strippedName, new LegacyCustomFile(fileType, file, isDynamic));
                break;
            }
            case YAML: {
                if (this.files.containsKey(strippedName)) {
                    this.files.get(strippedName).load();
                    return this;
                }
                this.files.put(strippedName, new LegacyCustomFile(fileType, file, isDynamic).load());
                break;
            }
            case JSON: {
                throw new FusionException("The file type with extension " + extension + " is not currently supported.");
            }
        }
        return this;
    }

    public LegacyFileManager saveFile(@NotNull String fileName) {
        if (fileName.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot save the file as the file is null or empty.");
            }
            return this;
        }
        String extension = FileType.YAML.getExtension();
        String strippedName = this.strip(fileName, extension);
        if (!this.files.containsKey(strippedName)) {
            if (this.isVerbose) {
                this.logger.warn("Cannot save the file as the file does not exist.");
            }
            return this;
        }
        this.files.get(strippedName).save();
        return this;
    }

    public LegacyFileManager removeFile(LegacyCustomFile customFile, boolean purge) {
        return this.removeFile(customFile.getFileName(), customFile.getFileType(), purge);
    }

    public LegacyFileManager removeFile(@NotNull String fileName, @NotNull FileType fileType, boolean purge) {
        if (fileName.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot remove the file as the file is null or empty.");
            }
            return this;
        }
        String strippedName = this.strip(fileName, fileType.getExtension());
        switch (fileType) {
            case YAML: {
                if (!this.files.containsKey(strippedName)) {
                    return this;
                }
                LegacyCustomFile customFile = this.files.remove(fileName);
                if (purge) {
                    customFile.delete();
                    return this;
                }
                customFile.save();
                break;
            }
            case NBT: {
                if (!this.files.containsKey(strippedName)) {
                    return this;
                }
                LegacyCustomFile customFile = this.files.remove(fileName);
                if (!purge) break;
                customFile.delete();
                return this;
            }
        }
        return this;
    }

    public LegacyFileManager reloadFiles() {
        ArrayList forRemoval = new ArrayList();
        this.files.forEach((name, file) -> {
            if (file.getFile().exists()) {
                if (file.getFileType() == FileType.YAML) {
                    file.load();
                }
            } else {
                forRemoval.add(name);
            }
        });
        forRemoval.forEach(this.files::remove);
        if (this.isVerbose && !forRemoval.isEmpty()) {
            this.logger.info("{} file(s) were removed from cache, because they did not exist.", (Object)forRemoval.size());
        }
        return this;
    }

    public LegacyFileManager init() {
        this.dataFolder.mkdirs();
        this.folders.forEach(this::addFolder);
        return this;
    }

    public LegacyFileManager purge() {
        this.folders.clear();
        this.files.clear();
        return this;
    }

    @Nullable
    public LegacyCustomFile getFile(String fileName, FileType fileType) {
        return this.files.getOrDefault(this.strip(fileName, fileType.getExtension()), null);
    }

    public String strip(String fileName, String extension) {
        return fileName.replace(extension, "");
    }

    public Map<String, LegacyCustomFile> getFiles() {
        return Collections.unmodifiableMap(this.files);
    }

    private void saveResource(@NotNull String resourcePath) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new FusionException("ResourcePath cannot be null or empty");
        }
        InputStream inputStream = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (inputStream == null) {
            throw new FusionException("The embedded resource '" + resourcePath + "' cannot be found.");
        }
        File outFile = new File(this.dataFolder, resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.dataFolder, resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (outDir.mkdirs() && this.isVerbose) {
            this.logger.warn("Created directory {}", (Object)outDir.getAbsolutePath());
        }
        try {
            if (!outFile.exists()) {
                int len;
                FileOutputStream outputStream = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    ((OutputStream)outputStream).write(buf, 0, len);
                }
                ((OutputStream)outputStream).close();
                inputStream.close();
            } else if (this.isVerbose) {
                this.logger.warn("Could not save {} to {} because {} already exists", outFile.getName(), outFile, outFile.getName());
            }
        }
        catch (IOException exception) {
            throw new FusionException("Failed to save " + resourcePath + " to " + outFile.getName(), exception);
        }
    }

    private InputStream getResource(@NotNull String path) {
        try {
            URL url = FileUtils.class.getClassLoader().getResource(path);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException exception) {
            throw new FusionException("Failed to get resource path " + path + " out of jar", exception);
        }
    }
}

