/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.files;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.api.LoggerImpl;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public final class LegacyCustomFile {
    private final FusionCore api = FusionCore.FusionProvider.get();
    private final LoggerImpl logger = this.api.getLogger();
    private final boolean isVerbose = this.api.isVerbose();
    private final String effectiveName;
    private final FileType fileType;
    private final boolean isDynamic;
    private final File file;
    private YamlConfiguration configuration;

    public LegacyCustomFile(FileType fileType, File file, boolean isDynamic) {
        this.effectiveName = file.getName().replace(".yml", "");
        this.isDynamic = isDynamic;
        this.fileType = fileType;
        this.file = file;
    }

    public LegacyCustomFile load() {
        block5: {
            if (this.fileType != FileType.YAML) {
                throw new FusionException("Only yaml files are supported by the load function.");
            }
            if (this.getFile().isDirectory()) {
                if (this.isVerbose) {
                    this.logger.warn("Cannot load configuration, as {} is a directory.", (Object)this.getFileName());
                }
                return this;
            }
            try {
                this.configuration = CompletableFuture.supplyAsync(() -> YamlConfiguration.loadConfiguration((File)this.file)).join();
            }
            catch (Exception exception) {
                if (!this.isVerbose) break block5;
                this.logger.warn("Cannot load configuration file: {}", this.getFileName(), exception);
            }
        }
        return this;
    }

    public LegacyCustomFile save() {
        if (this.fileType != FileType.YAML) {
            throw new FusionException("Only yaml files are supported by the save function.");
        }
        if (this.getFile().isDirectory()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot save configuration, as {} is a directory.", (Object)this.getFileName());
            }
            return this;
        }
        if (this.configuration == null) {
            if (this.isVerbose) {
                this.logger.severe("Configuration is null, cannot save {}!", (Object)this.getFileName());
            }
            return this;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.configuration.save(this.file);
            }
            catch (Exception exception) {
                throw new FusionException("Cannot save configuration file: " + this.getFileName(), exception);
            }
        });
        return this;
    }

    public void delete() {
        File file = this.getFile();
        if (file != null && file.exists() && file.delete() && this.isVerbose) {
            this.logger.warn("Successfully deleted {}", (Object)this.getFileName());
        }
    }

    @Nullable
    public YamlConfiguration getConfiguration() {
        if (this.fileType != FileType.YAML) {
            throw new FusionException("Only yaml files are supported by the getConfiguration function.");
        }
        return this.configuration;
    }

    public boolean isConfigurationLoaded() {
        if (this.fileType != FileType.YAML) {
            throw new FusionException("Only yaml files are supported by the isConfigurationLoaded function.");
        }
        return this.getConfiguration() != null;
    }

    public String getEffectiveName() {
        return this.effectiveName;
    }

    public LegacyCustomFile getInstance() {
        return this;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }
}

