/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.structure;

import java.io.File;
import java.io.IOException;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.paper.FusionPlugin;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureRegistry {
    private final Plugin plugin = FusionPlugin.getPlugin();
    private final StructureManager manager = this.plugin.getServer().getStructureManager();

    @Nullable
    public Structure getStructure(@NotNull String key) {
        return this.manager.getStructure(new NamespacedKey(this.plugin, key));
    }

    public void registerStructure(@NotNull File file, @NotNull String name) {
        Structure structure;
        StructureManager manager = this.manager;
        try {
            structure = manager.loadStructure(file);
        }
        catch (IOException exception) {
            throw new FusionException("Failed to load structure.", exception);
        }
        NamespacedKey key = new NamespacedKey(this.plugin, name);
        manager.registerStructure(key, structure);
    }

    public void unregisterStructure(@NotNull String name) {
        if (this.getStructure(name) == null) {
            return;
        }
        StructureManager manager = this.manager;
        manager.unregisterStructure(new NamespacedKey(this.plugin, name));
    }
}

