/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.scheduler;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.paper.FusionPlugin;
import libs.com.ryderbelserion.fusion.paper.api.enums.Scheduler;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FoliaScheduler
implements Runnable {
    private final Plugin plugin = FusionPlugin.getPlugin();
    private final Scheduler type;
    private final Server server = this.plugin.getServer();
    private final TimeUnit timeUnit;
    private ScheduledTask task;
    private World world;
    private int x;
    private int z;
    private Runnable retired;
    private Entity entity;

    public FoliaScheduler(@NotNull Scheduler type, @NotNull TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.type = type;
    }

    public FoliaScheduler(@NotNull Scheduler type) {
        this(type, TimeUnit.SECONDS);
    }

    public FoliaScheduler(@NotNull World world, int x, int z) {
        this(Scheduler.region_scheduler, TimeUnit.SECONDS);
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public FoliaScheduler(@NotNull Location location) {
        this(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public FoliaScheduler(@Nullable Runnable retired, @NotNull Entity entity) {
        this(Scheduler.entity_scheduler);
        this.retired = retired;
        this.entity = entity;
    }

    public ScheduledTask runNow() throws FusionException {
        this.isScheduled();
        this.task = switch (this.type) {
            case Scheduler.global_scheduler -> this.server.getGlobalRegionScheduler().run(this.plugin, scheduledTask -> this.run());
            case Scheduler.async_scheduler -> this.server.getAsyncScheduler().runNow(this.plugin, scheduledTask -> this.run());
            case Scheduler.region_scheduler -> this.server.getRegionScheduler().run(this.plugin, this.world, this.x, this.z, scheduledTask -> this.run());
            case Scheduler.entity_scheduler -> {
                if (this.entity == null) {
                    throw new FusionException("Cannot immediately run entity task if the entity is null.");
                }
                yield this.entity.getScheduler().run(this.plugin, scheduledTask -> this.run(), this.retired);
            }
            default -> throw new FusionException("The task type is not supported!");
        };
        return this.task;
    }

    public boolean execute() throws FusionException {
        this.isScheduled();
        switch (this.type) {
            case global_scheduler: {
                this.server.getGlobalRegionScheduler().execute(this.plugin, (Runnable)this);
                break;
            }
            case async_scheduler: {
                this.server.getAsyncScheduler().runNow(this.plugin, scheduledTask -> this.run());
                break;
            }
            case region_scheduler: {
                this.server.getRegionScheduler().run(this.plugin, this.world, this.x, this.z, scheduledTask -> this.run());
                break;
            }
            case entity_scheduler: {
                if (this.entity == null) {
                    throw new FusionException("Cannot immediately execute entity task if the entity is null.");
                }
                this.entity.getScheduler().run(this.plugin, scheduledTask -> this.run(), this.retired);
                break;
            }
            default: {
                throw new FusionException("The task type is not supported!");
            }
        }
        return true;
    }

    public ScheduledTask runDelayed(long delay) throws FusionException {
        this.isScheduled();
        delay = Math.max(1L, delay);
        this.task = switch (this.type) {
            case Scheduler.global_scheduler -> this.server.getGlobalRegionScheduler().runDelayed(this.plugin, scheduledTask -> this.run(), delay);
            case Scheduler.async_scheduler -> this.server.getAsyncScheduler().runDelayed(this.plugin, scheduledTask -> this.run(), delay, this.timeUnit);
            case Scheduler.region_scheduler -> this.server.getRegionScheduler().runDelayed(this.plugin, this.world, this.x, this.z, scheduledTask -> this.run(), delay);
            case Scheduler.entity_scheduler -> {
                if (this.entity == null) {
                    throw new FusionException("Cannot run delayed entity task if the entity is null.");
                }
                yield this.entity.getScheduler().runDelayed(this.plugin, scheduledTask -> this.run(), this.retired, delay);
            }
            default -> throw new FusionException("The task type is not supported!");
        };
        return this.task;
    }

    public ScheduledTask runNextTick() throws FusionException {
        this.isScheduled();
        this.task = switch (this.type) {
            case Scheduler.global_scheduler -> this.server.getGlobalRegionScheduler().run(this.plugin, scheduledTask -> this.run());
            case Scheduler.async_scheduler -> this.server.getAsyncScheduler().runDelayed(this.plugin, scheduledTask -> this.run(), 50L, TimeUnit.MILLISECONDS);
            case Scheduler.region_scheduler -> this.server.getRegionScheduler().run(this.plugin, this.world, this.x, this.z, scheduledTask -> this.run());
            case Scheduler.entity_scheduler -> {
                if (this.entity == null) {
                    throw new FusionException("Cannot run delayed entity task if the entity is null.");
                }
                yield this.entity.getScheduler().run(this.plugin, scheduledTask -> this.run(), this.retired);
            }
            default -> throw new FusionException("The task type is not supported!");
        };
        return this.task;
    }

    public ScheduledTask runAtFixedRate(long delay, long interval) throws FusionException {
        this.isScheduled();
        delay = Math.max(1L, delay);
        interval = Math.max(1L, interval);
        this.task = switch (this.type) {
            case Scheduler.global_scheduler -> this.server.getGlobalRegionScheduler().runAtFixedRate(this.plugin, scheduledTask -> this.run(), delay, interval);
            case Scheduler.async_scheduler -> this.server.getAsyncScheduler().runAtFixedRate(this.plugin, scheduledTask -> this.run(), delay, interval, this.timeUnit);
            case Scheduler.region_scheduler -> this.server.getRegionScheduler().runAtFixedRate(this.plugin, this.world, this.x, this.z, scheduledTask -> this.run(), delay, interval);
            case Scheduler.entity_scheduler -> {
                if (this.entity == null) {
                    throw new FusionException("Cannot run fixed rate entity task if the entity is null");
                }
                yield this.entity.getScheduler().runAtFixedRate(this.plugin, scheduledTask -> this.run(), this.retired, delay, interval);
            }
            default -> throw new FusionException("The task type is not supported!");
        };
        return this.task;
    }

    public void cancel(@Nullable Consumer<FoliaScheduler> consumer) {
        this.isNotScheduled();
        this.task.cancel();
        if (consumer != null) {
            consumer.accept(this);
        }
    }

    public void cancel() {
        this.cancel(null);
    }

    @Override
    public void run() {
    }

    public final int getTaskId() throws FusionException {
        this.isNotScheduled();
        return this.task.hashCode();
    }

    public final Scheduler getType() {
        return this.type;
    }

    public final ScheduledTask getTask() {
        return this.task;
    }

    private void isNotScheduled() throws FusionException {
        if (this.task == null) {
            throw new FusionException("The task is not yet scheduled.");
        }
    }

    private void isScheduled() throws FusionException {
        if (this.task != null) {
            throw new FusionException("The task is already scheduled as " + this.task.hashCode());
        }
    }
}

