/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import libs.com.ryderbelserion.fusion.core.api.commands.Command;
import libs.com.ryderbelserion.fusion.core.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.paper.api.commands.context.PaperCommandContext;
import org.jetbrains.annotations.NotNull;

public abstract class PaperCommand
extends Command<CommandSourceStack, PaperCommandContext> {
    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestStringArgument(SuggestionsBuilder builder, int min, int max, @NotNull String tooltip) {
        for (int count = min; count <= max; ++count) {
            String uuid = UUID.randomUUID().toString().replace("-", "").substring(0, 8);
            if (tooltip.isBlank()) {
                builder.suggest(uuid);
                continue;
            }
            builder.suggest(uuid, (Message)MessageComponentSerializer.message().serialize(AdvUtils.parse(tooltip)));
        }
        return builder.buildFuture();
    }

    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestStringArgument(SuggestionsBuilder builder, @NotNull String tooltip) {
        return this.suggestStringArgument(builder, 1, 8, tooltip);
    }

    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestStringArgument(SuggestionsBuilder builder) {
        return this.suggestStringArgument(builder, "");
    }

    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestIntegerArgument(SuggestionsBuilder builder, int min, int max, @NotNull String tooltip) {
        for (int count = min; count <= max; ++count) {
            if (tooltip.isBlank()) {
                builder.suggest(count);
                continue;
            }
            builder.suggest(count, (Message)MessageComponentSerializer.message().serialize(AdvUtils.parse(tooltip)));
        }
        return builder.buildFuture();
    }

    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestIntegerArgument(SuggestionsBuilder builder, @NotNull String tooltip) {
        return this.suggestIntegerArgument(builder, 1, 64, tooltip);
    }

    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestIntegerArgument(SuggestionsBuilder builder) {
        return this.suggestIntegerArgument(builder, "");
    }

    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestDoubleArgument(SuggestionsBuilder builder, int min, int max, @NotNull String tooltip) {
        for (int count = min; count <= max; ++count) {
            double x = (double)count / 10.0;
            String value = String.valueOf(x);
            if (tooltip.isBlank()) {
                builder.suggest(value);
                continue;
            }
            builder.suggest(value, (Message)MessageComponentSerializer.message().serialize(AdvUtils.parse(tooltip)));
        }
        return builder.buildFuture();
    }

    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestDoubleArgument(SuggestionsBuilder builder, @NotNull String tooltip) {
        return this.suggestDoubleArgument(builder, 0, 64, tooltip);
    }

    @Override
    @NotNull
    public CompletableFuture<Suggestions> suggestDoubleArgument(SuggestionsBuilder builder) {
        return this.suggestDoubleArgument(builder, "");
    }
}

