/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types;

import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.BaseItemBuilder;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerBuilder
extends BaseItemBuilder<SpawnerBuilder> {
    private EntityType entityType;
    private int count = 0;
    private int delay = 3;
    private int range = 0;

    public SpawnerBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    public SpawnerBuilder withEntityType(@Nullable EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    public SpawnerBuilder withSpawnCount(int count) {
        this.count = count;
        return this;
    }

    public SpawnerBuilder withSpawnDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public SpawnerBuilder withSpawnRange(int range) {
        this.range = range;
        return this;
    }

    @Override
    public SpawnerBuilder build() {
        if (this.entityType == null) {
            return this;
        }
        this.getItem().editMeta(itemMeta -> {
            if (itemMeta instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)itemMeta;
                if (this.count > 0) {
                    spawner.setSpawnCount(this.count);
                }
                if (this.delay > 0) {
                    spawner.setDelay(this.delay);
                }
                if (this.range > 0) {
                    spawner.setSpawnRange(this.range);
                }
                spawner.setSpawnedType(this.entityType);
            }
        });
        return this;
    }
}

