/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.PotionContents;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.BaseItemBuilder;
import libs.com.ryderbelserion.fusion.paper.utils.ColorUtils;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class PotionBuilder
extends BaseItemBuilder<PotionBuilder> {
    private final PotionContents.Builder builder = PotionContents.potionContents();

    public PotionBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    public PotionBuilder withPotionEffect(PotionEffectType potionEffectType, int duration, int amplifier, boolean isAmbient, boolean isParticles, boolean hasIcon) {
        this.builder.addCustomEffect(new PotionEffect(potionEffectType, duration, amplifier).withAmbient(isAmbient).withParticles(isParticles).withIcon(hasIcon));
        return this;
    }

    public PotionBuilder withPotionEffect(PotionEffectType potionEffectType, int duration, int amplifier) {
        return this.withPotionEffect(potionEffectType, duration, amplifier, true, true, true);
    }

    public PotionBuilder withPotionType(PotionType potionType) {
        this.builder.potion(potionType);
        return this;
    }

    public PotionBuilder withCustomName(String customName) {
        this.builder.customName(customName);
        return this;
    }

    @Override
    public PotionBuilder setColor(@NotNull String value) {
        this.builder.customColor(ColorUtils.getColor(value));
        return this;
    }

    @Override
    public PotionBuilder build() {
        this.getItem().setData(DataComponentTypes.POTION_CONTENTS, (Object)((PotionContents)this.builder.build()));
        return this;
    }
}

