/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builder.items.modern;

import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.BaseItemBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.PatternBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.PotionBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.SkullBuilder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder
extends BaseItemBuilder<ItemBuilder> {
    ItemBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    ItemBuilder(@NotNull String value) {
        super(value);
    }

    public static PotionBuilder potion(@NotNull ItemType itemType, int amount) {
        return new PotionBuilder(itemType.createItemStack(Math.max(amount, 1)));
    }

    public static PotionBuilder potion(@NotNull ItemType itemType) {
        return ItemBuilder.potion(itemType, 1);
    }

    public static SkullBuilder skull(@NotNull ItemType itemType, int amount) {
        return new SkullBuilder(itemType.createItemStack(Math.max(amount, 1)));
    }

    public static SkullBuilder skull(@NotNull ItemType itemType) {
        return ItemBuilder.skull(itemType, 1);
    }

    public static PatternBuilder pattern(@NotNull ItemType itemType, int amount) {
        return new PatternBuilder(itemType.createItemStack(Math.max(amount, 1)));
    }

    public static PatternBuilder pattern(@NotNull ItemType itemType) {
        return ItemBuilder.pattern(itemType, 1);
    }

    public static ItemBuilder from(@NotNull ItemType itemType, int amount) {
        return new ItemBuilder(itemType.createItemStack(Math.max(amount, 1)));
    }

    public static ItemBuilder from(@NotNull ItemStack itemStack) {
        return new ItemBuilder(itemStack);
    }

    public static ItemBuilder from(@NotNull ItemType itemType) {
        return ItemBuilder.from(itemType, 1);
    }

    public static ItemBuilder from(@NotNull String value) {
        return new ItemBuilder(value);
    }
}

