/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builder.items.modern;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.nexomc.nexo.api.NexoItems;
import dev.lone.itemsadder.api.CustomStack;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.ItemArmorTrim;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.MapItemColor;
import io.papermc.paper.datacomponent.item.Unbreakable;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.items.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.api.utils.StringUtils;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.api.LoggerImpl;
import libs.com.ryderbelserion.fusion.paper.FusionPlugin;
import libs.com.ryderbelserion.fusion.paper.api.builder.ComponentBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.PatternBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.PotionBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.SkullBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.SpawnerBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.fireworks.FireworkBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builder.items.modern.types.fireworks.FireworkStarBuilder;
import libs.com.ryderbelserion.fusion.paper.api.enums.Support;
import libs.com.ryderbelserion.fusion.paper.utils.ColorUtils;
import libs.com.ryderbelserion.fusion.paper.utils.ItemUtils;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public abstract class BaseItemBuilder<B extends BaseItemBuilder<B>> {
    protected final Plugin plugin = FusionPlugin.getPlugin();
    private final FusionCore api = FusionCore.FusionProvider.get();
    private final boolean isVerbose = this.api.isVerbose();
    private final LoggerImpl logger = this.api.getLogger();
    private final List<ItemFlag> itemflags = new ArrayList<ItemFlag>();
    private Map<String, String> placeholders = new HashMap<String, String>();
    private List<String> displayLore = new ArrayList<String>();
    private String displayName = null;
    private boolean isStatic = false;
    private ItemType itemType;
    private ItemStack item;

    public BaseItemBuilder(ItemStack item) {
        this.itemType = item.getType().asItemType();
        this.item = item;
    }

    public BaseItemBuilder(String item) {
        this.withCustomItem(item);
    }

    public ItemStack asItemStack(@Nullable Audience audience, boolean isLegacy) {
        ComponentBuilder builder;
        if (this.displayName != null) {
            if (isLegacy) {
                this.item.editMeta(itemMeta -> itemMeta.setDisplayName(ColorUtils.color(this.withPlaceholders(audience, this.displayName))));
            } else {
                builder = new ComponentBuilder(this.displayName);
                this.item.setData(this.isStatic ? DataComponentTypes.ITEM_NAME : DataComponentTypes.CUSTOM_NAME, (Object)builder.asComponent(audience, this.placeholders));
            }
        }
        if (!this.displayLore.isEmpty()) {
            if (isLegacy) {
                ArrayList<String> lines = new ArrayList<String>();
                for (String line : this.displayLore) {
                    lines.add(ColorUtils.color(this.withPlaceholders(audience, line)));
                }
                this.item.editMeta(itemMeta -> itemMeta.setLore(lines));
            } else {
                builder = new ComponentBuilder(this.displayLore);
                this.item.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(builder.asComponents(audience, this.placeholders)));
            }
        }
        if (!this.itemflags.isEmpty()) {
            this.item.editMeta(itemMeta -> this.itemflags.forEach(flag -> {
                itemMeta.addItemFlags(new ItemFlag[]{flag});
                if (flag == ItemFlag.HIDE_ATTRIBUTES) {
                    itemMeta.setAttributeModifiers((Multimap)ImmutableMultimap.of());
                }
            }));
        }
        this.build();
        return this.item;
    }

    public ItemStack asItemStack(boolean isLegacy) {
        return this.asItemStack(null, isLegacy);
    }

    public ItemStack asItemStack() {
        return this.asItemStack(false);
    }

    public B build() {
        return (B)this;
    }

    public B withCustomItem(String item) {
        switch (this.api.getItemsPlugin().toLowerCase()) {
            case "nexo": {
                if (Support.nexo.isEnabled()) {
                    this.getNexo(item);
                    return (B)this;
                }
                this.setItem(item);
                break;
            }
            case "oraxen": {
                if (Support.oraxen.isEnabled()) {
                    this.getOraxen(item);
                    return (B)this;
                }
                this.setItem(item);
                break;
            }
            case "itemsadder": {
                if (Support.items_adder.isEnabled()) {
                    this.getItemsAdder(item);
                    return (B)this;
                }
                this.setItem(item);
                break;
            }
            case "none": {
                this.setItem(item);
                break;
            }
            default: {
                if (Support.nexo.isEnabled()) {
                    this.getNexo(item);
                    return (B)this;
                }
                if (Support.items_adder.isEnabled()) {
                    this.getItemsAdder(item);
                    return (B)this;
                }
                if (Support.oraxen.isEnabled()) {
                    this.getOraxen(item);
                    return (B)this;
                }
                this.setItem(item);
            }
        }
        return (B)this;
    }

    public B withBase64(@NotNull String base64) {
        if (base64.isEmpty()) {
            return (B)this;
        }
        try {
            this.item = ItemUtils.fromBase64(base64);
        }
        catch (Exception exception) {
            this.item = ItemType.STONE.createItemStack(1);
        }
        this.itemType = this.item.getType().asItemType();
        return (B)this;
    }

    public B withType(@Nullable ItemType type, int amount) {
        if (type == null) {
            throw new FusionException("The item type cannot be null!");
        }
        if (this.item == null) {
            this.item = type.createItemStack(Math.max(amount, 1));
        }
        this.itemType = this.item.getType().asItemType();
        return (B)this;
    }

    public B withType(@Nullable ItemType type) {
        return this.withType(type, 1);
    }

    @Deprecated(since="0.16.0", forRemoval=true)
    public B withType(@NotNull String key) {
        if (key.isEmpty()) {
            return (B)this;
        }
        this.withCustomItem(key);
        if (key.contains(":")) {
            Optional<Number> damage;
            String model;
            Optional<Number> customModelData;
            String[] sections = key.split(":");
            String data = sections[1];
            if (data.contains("#") && (customModelData = StringUtils.tryParseInt(model = data.split("#")[1])).isPresent()) {
                Number number2 = customModelData.get();
                data = data.replace("#" + number2.intValue(), "");
            }
            if ((damage = StringUtils.tryParseInt(data)).isEmpty()) {
                @org.jetbrains.annotations.Nullable PotionEffectType potionEffect = ItemUtils.getPotionEffect(data);
                PotionBuilder potionBuilder = this.asPotionBuilder();
                potionBuilder.setColor(data).withPotionType(ItemUtils.getPotionType(data)).withPotionEffect(potionEffect, 1, 1);
            } else {
                this.setItemDamage(damage.get().intValue());
            }
        } else if (key.contains("#")) {
            String[] sections = key.split("#");
            String model = sections[1];
            Optional<Number> customModelData = StringUtils.tryParseInt(model);
            customModelData.ifPresent(number -> this.setCustomModelData(number.intValue()));
        }
        return (B)this;
    }

    public B addEnchantment(@NotNull String enchant, int level) {
        ItemEnchantments enchantments;
        if (enchant.isEmpty()) {
            return (B)this;
        }
        Enchantment enchantment = ItemUtils.getEnchantment(enchant);
        if (enchantment == null) {
            return (B)this;
        }
        ItemEnchantments.Builder builder = ItemEnchantments.itemEnchantments();
        if (this.isBook() && this.item.hasData((DataComponentType)DataComponentTypes.STORED_ENCHANTMENTS)) {
            ItemEnchantments enchantments2 = (ItemEnchantments)this.item.getData(DataComponentTypes.STORED_ENCHANTMENTS);
            if (enchantments2 != null) {
                builder.addAll(enchantments2.enchantments());
            }
        } else if (this.item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENTS) && (enchantments = (ItemEnchantments)this.item.getData(DataComponentTypes.ENCHANTMENTS)) != null) {
            builder.addAll(enchantments.enchantments());
        }
        builder.add(enchantment, level);
        this.item.setData(this.isBook() ? DataComponentTypes.STORED_ENCHANTMENTS : DataComponentTypes.ENCHANTMENTS, (Object)((ItemEnchantments)builder.build()));
        return (B)this;
    }

    public B removeEnchantment(@NotNull String enchant) {
        if (enchant.isEmpty()) {
            return (B)this;
        }
        Enchantment enchantment = ItemUtils.getEnchantment(enchant);
        if (enchantment == null) {
            return (B)this;
        }
        this.item.removeEnchantment(enchantment);
        return (B)this;
    }

    public B setAmount(int amount) {
        this.item.setAmount(Math.max(amount, 1));
        return (B)this;
    }

    public B setDisplayName(@Nullable String displayName, boolean isStatic) {
        this.displayName = displayName;
        this.isStatic = isStatic;
        return (B)this;
    }

    public B setDisplayName(@Nullable String displayName) {
        return this.setDisplayName(displayName, false);
    }

    public String getPlainName() {
        Component custom_name;
        TextComponent component = Component.empty();
        if (this.item.hasData((DataComponentType)DataComponentTypes.ITEM_NAME)) {
            Component item_name = (Component)this.item.getData(DataComponentTypes.ITEM_NAME);
            if (item_name != null) {
                component = item_name;
            }
        } else if (this.item.hasData((DataComponentType)DataComponentTypes.CUSTOM_NAME) && (custom_name = (Component)this.item.getData(DataComponentTypes.CUSTOM_NAME)) != null) {
            component = custom_name;
        }
        return (String)PlainTextComponentSerializer.plainText().serializeOr((Component)component, (Object)"");
    }

    public B withDisplayLore(@NotNull List<String> displayLore) {
        this.displayLore = displayLore;
        return (B)this;
    }

    public B addDisplayLore(@NotNull String displayLore) {
        if (displayLore.isEmpty()) {
            return (B)this;
        }
        this.displayLore.add(displayLore);
        return (B)this;
    }

    public List<String> getPlainLore() {
        ItemLore lore;
        ArrayList<String> plainLore = new ArrayList<String>();
        if (this.item.hasData((DataComponentType)DataComponentTypes.LORE) && (lore = (ItemLore)this.item.getData(DataComponentTypes.LORE)) != null) {
            lore.lines().forEach(line -> plainLore.add(PlainTextComponentSerializer.plainText().serialize(line)));
        }
        return plainLore;
    }

    public B setEnchantGlint(boolean enchantGlintOverride) {
        if (enchantGlintOverride && !this.item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            this.item.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)enchantGlintOverride);
            return (B)this;
        }
        if (this.item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            this.item.unsetData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
        }
        return (B)this;
    }

    public B removeEnchantGlint() {
        if (!this.item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            return (B)this;
        }
        this.item.unsetData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
        return (B)this;
    }

    public B hideToolTip() {
        if (this.item.hasData((DataComponentType)DataComponentTypes.HIDE_TOOLTIP)) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.HIDE_TOOLTIP);
        return (B)this;
    }

    public B showToolTip() {
        if (!this.item.hasData((DataComponentType)DataComponentTypes.HIDE_TOOLTIP)) {
            return (B)this;
        }
        this.item.unsetData((DataComponentType)DataComponentTypes.HIDE_TOOLTIP);
        return (B)this;
    }

    public B hideAdditionalToolTip() {
        if (this.item.hasData((DataComponentType)DataComponentTypes.HIDE_TOOLTIP) || this.item.hasData((DataComponentType)DataComponentTypes.HIDE_ADDITIONAL_TOOLTIP)) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.HIDE_ADDITIONAL_TOOLTIP);
        return (B)this;
    }

    public B showAdditionalToolTip() {
        if (!this.item.hasData((DataComponentType)DataComponentTypes.HIDE_ADDITIONAL_TOOLTIP)) {
            return (B)this;
        }
        this.item.unsetData((DataComponentType)DataComponentTypes.HIDE_ADDITIONAL_TOOLTIP);
        return (B)this;
    }

    public B addItemFlag(ItemFlag itemFlag) {
        this.itemflags.add(itemFlag);
        return (B)this;
    }

    public B addItemFlags(List<String> flags) {
        flags.forEach(this::addItemFlag);
        return (B)this;
    }

    public B removeItemFlags(List<String> flags) {
        flags.forEach(this::removeItemFlag);
        return (B)this;
    }

    public B addItemFlag(String flag) {
        ItemFlag itemFlag = this.getFlag(flag);
        if (itemFlag == null) {
            throw new FusionException("Flag " + flag + " is not a valid flag");
        }
        this.addItemFlag(itemFlag);
        return (B)this;
    }

    public B removeItemFlag(String flag) {
        ItemFlag itemFlag = this.getFlag(flag);
        if (itemFlag == null) {
            throw new FusionException("Flag " + flag + " is not a valid flag");
        }
        this.item.editMeta(itemMeta -> itemMeta.removeItemFlags(new ItemFlag[]{itemFlag}));
        this.itemflags.remove(itemFlag);
        return (B)this;
    }

    public B setUnbreakable(boolean isUnbreakable) {
        if (isUnbreakable && !this.item.hasData((DataComponentType)DataComponentTypes.UNBREAKABLE)) {
            this.item.setData(DataComponentTypes.UNBREAKABLE, (Object)((Unbreakable)Unbreakable.unbreakable().build()));
            return (B)this;
        }
        if (this.item.hasData((DataComponentType)DataComponentTypes.UNBREAKABLE)) {
            this.item.unsetData((DataComponentType)DataComponentTypes.UNBREAKABLE);
        }
        return (B)this;
    }

    public B setCustomModelData(int customModelData) {
        CustomModelData component;
        if (customModelData == -1) {
            return (B)this;
        }
        CustomModelData.Builder data = CustomModelData.customModelData();
        if (this.item.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA) && (component = (CustomModelData)this.item.getData(DataComponentTypes.CUSTOM_MODEL_DATA)) != null) {
            data.addFloats(component.floats()).addStrings(component.strings()).addFlags(component.flags()).addColors(component.colors());
        }
        this.item.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)data.addFloat((float)customModelData).build()));
        return (B)this;
    }

    public B setCustomModelData(String customModelData) {
        CustomModelData component;
        if (customModelData.isEmpty()) {
            return (B)this;
        }
        CustomModelData.Builder data = CustomModelData.customModelData();
        if (this.item.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA) && (component = (CustomModelData)this.item.getData(DataComponentTypes.CUSTOM_MODEL_DATA)) != null) {
            data.addFloats(component.floats()).addStrings(component.strings()).addFlags(component.flags()).addColors(component.colors());
        }
        this.item.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)data.addString(customModelData).build()));
        return (B)this;
    }

    public B setItemModel(@NotNull String itemModel) {
        if (itemModel.isEmpty()) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.ITEM_MODEL, (Object)NamespacedKey.minecraft((String)itemModel));
        return (B)this;
    }

    public B setItemModel(@NotNull String namespace, @NotNull String itemModel) {
        if (namespace.isEmpty() || itemModel.isEmpty()) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.ITEM_MODEL, (Object)new NamespacedKey(namespace, itemModel));
        return (B)this;
    }

    public B setTrim(@NotNull String pattern, @NotNull String material, boolean hideToolTip) {
        if (pattern.isEmpty() || material.isEmpty()) {
            return (B)this;
        }
        TrimMaterial trimMaterial = ItemUtils.getTrimMaterial(material);
        if (trimMaterial == null) {
            return (B)this;
        }
        TrimPattern trimPattern = ItemUtils.getTrimPattern(pattern);
        if (trimPattern == null) {
            return (B)this;
        }
        ItemArmorTrim.Builder builder = (ItemArmorTrim.Builder)ItemArmorTrim.itemArmorTrim((ArmorTrim)new ArmorTrim(trimMaterial, trimPattern)).showInTooltip(hideToolTip);
        this.item.setData(DataComponentTypes.TRIM, (Object)((ItemArmorTrim)builder.build()));
        return (B)this;
    }

    public B setColor(@NotNull String value) {
        if (value.isEmpty()) {
            return (B)this;
        }
        if (this.isMap()) {
            Color color;
            Color color2 = color = value.contains(",") ? ColorUtils.getRGB(value) : ColorUtils.getColor(value);
            if (color != null) {
                this.item.setData(DataComponentTypes.MAP_COLOR, (Object)((MapItemColor)MapItemColor.mapItemColor().color(color).build()));
            }
        } else if (this.isLeather() || this.isPotion()) {
            Color color;
            Color color3 = color = value.contains(",") ? ColorUtils.getRGB(value) : ColorUtils.getColor(value);
            if (color != null) {
                this.item.setData(DataComponentTypes.DYED_COLOR, (Object)((DyedItemColor)DyedItemColor.dyedItemColor().color(color).build()));
            }
        } else if (this.isShield()) {
            DyeColor color = ColorUtils.getDyeColor(value);
            this.item.setData(DataComponentTypes.BASE_COLOR, (Object)color);
        }
        return (B)this;
    }

    public B setItemDamage(int damage) {
        if (damage <= 0) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.DAMAGE, (Object)Math.min(damage, this.getType().getMaxDurability()));
        return (B)this;
    }

    public B addPlaceholder(String placeholder, String value) {
        this.placeholders.put(placeholder, value);
        return (B)this;
    }

    public B setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
        return (B)this;
    }

    public boolean hasPlaceholder(String placeholder) {
        return this.placeholders.containsKey(placeholder);
    }

    public B removePlaceholder(String placeholder) {
        this.placeholders.remove(placeholder);
        return (B)this;
    }

    public B withSkull(String skull) {
        HeadDatabaseAPI hdb = (HeadDatabaseAPI)this.api.getHeadDatabaseAPI();
        if (skull.isEmpty() || hdb == null) {
            return (B)this;
        }
        this.item = hdb.isHead(skull) ? hdb.getItemHead(skull) : ItemType.PLAYER_HEAD.createItemStack();
        return (B)this;
    }

    public FireworkBuilder asFireworkBuilder() {
        if (!this.isFirework()) {
            throw new FusionException("This item type is not a firework rocket.");
        }
        return new FireworkBuilder(this.item);
    }

    public FireworkStarBuilder asFireworkStarBuilder() {
        if (!this.isFireworkStar()) {
            throw new FusionException("This item type is not a firework star.");
        }
        return new FireworkStarBuilder(this.item);
    }

    public PatternBuilder asPatternBuilder() {
        if (this.isShield() || this.isBanner()) {
            return new PatternBuilder(this.item);
        }
        throw new FusionException("This item type is not a shield/banner.");
    }

    public SkullBuilder asSkullBuilder() {
        if (!this.isPlayerHead()) {
            throw new FusionException("This item type is not a skull.");
        }
        return new SkullBuilder(this.item);
    }

    public PotionBuilder asPotionBuilder() {
        if (this.isPotion() || this.isTippedArrow()) {
            return new PotionBuilder(this.item);
        }
        throw new FusionException("This item type is not a potion / tipped arrow.");
    }

    public SpawnerBuilder asSpawnerBuilder() {
        if (!this.isSpawner()) {
            throw new FusionException("This item type is not a spawner.");
        }
        return new SpawnerBuilder(this.item);
    }

    public void setItemToInventory(Audience audience, Inventory inventory, int slot, boolean isLegacy) {
        inventory.setItem(slot, this.asItemStack(audience, isLegacy));
    }

    public void addItemToInventory(Audience audience, Inventory inventory, boolean isLegacy) {
        inventory.addItem(new ItemStack[]{this.asItemStack(audience, isLegacy)});
    }

    public void setItemToInventory(Audience audience, Inventory inventory, int slot) {
        inventory.setItem(slot, this.asItemStack(audience, false));
    }

    public void addItemToInventory(Audience audience, Inventory inventory) {
        inventory.addItem(new ItemStack[]{this.asItemStack(audience, false)});
    }

    public void setItemToInventory(Inventory inventory, int slot) {
        this.setItemToInventory(null, inventory, slot);
    }

    public void addItemToInventory(Inventory inventory) {
        this.addItemToInventory(null, inventory);
    }

    public final boolean isDyeable() {
        return this.isTippedArrow() || this.isShield() || this.isLeather() || this.isMap();
    }

    public final boolean isPlayerHead() {
        return this.asString().equalsIgnoreCase(ItemType.PLAYER_HEAD.key().asString());
    }

    public final boolean isFireworkStar() {
        return this.asString().equalsIgnoreCase(ItemType.FIREWORK_STAR.key().asString());
    }

    public final boolean isTippedArrow() {
        return this.asString().equalsIgnoreCase(ItemType.TIPPED_ARROW.key().asString());
    }

    public final boolean isFirework() {
        return this.asString().equalsIgnoreCase(ItemType.FIREWORK_ROCKET.key().asString());
    }

    public final boolean isSpawner() {
        return this.asString().equalsIgnoreCase(ItemType.SPAWNER.key().asString());
    }

    public final boolean isShield() {
        return this.asString().equalsIgnoreCase(ItemType.SHIELD.key().asString());
    }

    public final boolean isEdible() {
        return this.itemType.isEdible();
    }

    public final boolean isLeather() {
        String id = this.asString();
        return id.equalsIgnoreCase(ItemType.LEATHER_HELMET.key().asString()) || id.equalsIgnoreCase(ItemType.LEATHER_CHESTPLATE.key().asString()) || id.equalsIgnoreCase(ItemType.LEATHER_LEGGINGS.key().asString()) || id.equalsIgnoreCase(ItemType.LEATHER_BOOTS.key().asString()) || id.equalsIgnoreCase(ItemType.LEATHER_HORSE_ARMOR.key().asString());
    }

    public final boolean isPotion() {
        String id = this.asString();
        return id.equalsIgnoreCase(ItemType.POTION.key().asString()) || id.equalsIgnoreCase(ItemType.SPLASH_POTION.key().asString()) || id.equalsIgnoreCase(ItemType.LINGERING_POTION.key().asString());
    }

    public final boolean isBanner() {
        return this.getId().endsWith("_banner");
    }

    public final boolean isBook() {
        return this.asString().equalsIgnoreCase(ItemType.ENCHANTED_BOOK.key().asString());
    }

    public final boolean isMap() {
        return this.asString().equalsIgnoreCase(ItemType.FILLED_MAP.key().asString());
    }

    public final String getNamespace() {
        return this.getKey().namespace();
    }

    public final String asString() {
        return this.getKey().asString();
    }

    public final String getId() {
        return this.getKey().value();
    }

    public final Key getKey() {
        return this.itemType.key();
    }

    protected final void setItemStack(ItemStack item) {
        this.item = item;
        this.itemType = this.item.getType().asItemType();
    }

    protected final ItemStack getItem() {
        return this.item;
    }

    protected final ItemType getType() {
        return this.itemType;
    }

    private void getItemsAdder(String item) {
        if (!CustomStack.isInRegistry((String)item)) {
            return;
        }
        CustomStack builder = CustomStack.getInstance((String)item);
        if (builder == null) {
            throw new FusionException("The id " + item + " is not a valid ItemsAdder item!");
        }
        this.item = builder.getItemStack();
        this.itemType = this.item.getType().asItemType();
    }

    private void getOraxen(String item) {
        if (!OraxenItems.exists((String)item)) {
            return;
        }
        ItemBuilder builder = OraxenItems.getItemById((String)item);
        if (builder == null) {
            throw new FusionException("The id " + item + " is not a valid Oraxen item!");
        }
        this.item = builder.build();
        this.itemType = this.item.getType().asItemType();
    }

    private void getNexo(String item) {
        if (!NexoItems.exists((String)item)) {
            return;
        }
        com.nexomc.nexo.items.ItemBuilder builder = NexoItems.itemFromId((String)item);
        if (builder == null) {
            throw new FusionException("The id " + item + " is not a valid Nexo item!");
        }
        this.item = builder.build();
        this.itemType = this.item.getType().asItemType();
    }

    private String withPlaceholders(@Nullable Audience audience, String line) {
        String clonedLine = line;
        for (Map.Entry<String, String> placeholder : this.placeholders.entrySet()) {
            if (placeholder == null) continue;
            String key = placeholder.getKey();
            String value = placeholder.getValue();
            if (value == null) continue;
            clonedLine = clonedLine.replace(key, value).replace(key.toLowerCase(), value);
        }
        if (audience instanceof Player) {
            Player player = (Player)audience;
            if (Support.placeholder_api.isEnabled()) {
                clonedLine = PlaceholderAPI.setPlaceholders((Player)player, (String)clonedLine);
            }
        }
        return clonedLine;
    }

    private void setItem(String item) {
        ItemType itemType = ItemUtils.getItemType(item);
        if (itemType != null) {
            this.withType(itemType);
        } else {
            this.withBase64(item);
        }
    }

    private @Nullable ItemFlag getFlag(String name) {
        ItemFlag flag = null;
        for (ItemFlag value : ItemFlag.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            flag = value;
            break;
        }
        return flag;
    }
}

