/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builder.items;

import java.util.Collections;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtBuilder {
    private ItemStack itemStack;

    public NbtBuilder() {
        this((ItemType)ItemType.STONE, 1);
    }

    public NbtBuilder(@NotNull ItemType itemType) {
        this(itemType, 1);
    }

    public NbtBuilder(@NotNull ItemType itemType, int amount) {
        this(itemType.createItemStack(amount), true);
    }

    public NbtBuilder(@NotNull ItemStack itemStack, boolean createNewStack) {
        this.itemStack = createNewStack ? itemStack.clone() : itemStack;
    }

    public final boolean hasItemMeta() {
        return !this.itemStack.hasItemMeta();
    }

    @NotNull
    public final NbtBuilder setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        return this;
    }

    @NotNull
    public final NbtBuilder setPersistentDouble(@NotNull NamespacedKey key, double value) {
        this.itemStack.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().set(key, PersistentDataType.DOUBLE, (Object)value));
        return this;
    }

    @NotNull
    public final NbtBuilder setPersistentInteger(@NotNull NamespacedKey key, int value) {
        this.itemStack.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value));
        return this;
    }

    @NotNull
    public final NbtBuilder setPersistentBoolean(@NotNull NamespacedKey key, boolean value) {
        this.itemStack.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().set(key, PersistentDataType.BOOLEAN, (Object)value));
        return this;
    }

    @NotNull
    public final NbtBuilder setPersistentString(@NotNull NamespacedKey key, @NotNull String value) {
        this.itemStack.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)value));
        return this;
    }

    @NotNull
    public final NbtBuilder setPersistentList(@NotNull NamespacedKey key, @NotNull List<String> values) {
        this.itemStack.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().set(key, (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)values));
        return this;
    }

    public final boolean getBoolean(@NotNull NamespacedKey key) {
        return (Boolean)this.itemStack.getPersistentDataContainer().getOrDefault(key, PersistentDataType.BOOLEAN, (Object)false);
    }

    public final double getDouble(@NotNull NamespacedKey key) {
        return (Double)this.itemStack.getPersistentDataContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)0.0);
    }

    public final int getInteger(@NotNull NamespacedKey key) {
        return (Integer)this.itemStack.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    @NotNull
    public final List<String> getList(@NotNull NamespacedKey key) {
        return (List)this.itemStack.getPersistentDataContainer().getOrDefault(key, (PersistentDataType)PersistentDataType.LIST.strings(), Collections.emptyList());
    }

    @NotNull
    public final String getString(@NotNull NamespacedKey key) {
        return (String)this.itemStack.getPersistentDataContainer().getOrDefault(key, PersistentDataType.STRING, (Object)"");
    }

    @NotNull
    public final NbtBuilder removePersistentKey(@Nullable NamespacedKey key) {
        if (key == null) {
            return this;
        }
        if (!this.itemStack.getPersistentDataContainer().has(key)) {
            return this;
        }
        this.itemStack.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().remove(key));
        return this;
    }

    public final boolean hasKey(@NotNull NamespacedKey key) {
        return this.itemStack.getPersistentDataContainer().has(key);
    }

    public final ItemStack getItemStack() {
        return this.itemStack;
    }
}

