/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builder;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import libs.com.ryderbelserion.fusion.paper.FusionPlugin;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerBuilder(String name) {
    @NotNull
    private static final Plugin plugin = FusionPlugin.getPlugin();
    @NotNull
    private static final Server server = plugin.getServer();

    @Nullable
    public PlayerProfile getOfflineProfile() {
        if (this.name.isEmpty()) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> server.createProfile(this.name)).join();
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer() {
        if (this.name.isEmpty()) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> server.getOfflinePlayer(this.name)).join();
    }

    @Nullable
    public Player getPlayer() {
        if (this.name.isEmpty()) {
            return null;
        }
        return server.getPlayerExact(this.name);
    }

    @Nullable
    public UUID getUniqueId() {
        if (this.name.isEmpty()) {
            return null;
        }
        Player player = this.getPlayer();
        if (player == null) {
            PlayerProfile profile = this.getOfflineProfile();
            if (profile != null) {
                return profile.getId();
            }
            OfflinePlayer offlinePlayer = this.getOfflinePlayer();
            if (offlinePlayer != null) {
                return offlinePlayer.getUniqueId();
            }
            return null;
        }
        return player.getUniqueId();
    }
}

