/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.paper.utils.ColorUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentBuilder {
    private final FusionCore api = FusionCore.FusionProvider.get();
    private final Map<ResolverType, List<TagResolver>> resolvers = new HashMap<ResolverType, List<TagResolver>>();
    private final List<String> lines = new ArrayList<String>();

    public ComponentBuilder(String line) {
        this(List.of(line));
    }

    public ComponentBuilder(List<String> lines) {
        lines.forEach(line -> this.lines.add(line.replaceAll("\\{", "<").replaceAll("}", ">")));
    }

    public List<Component> asComponents(@Nullable Audience audience, @NotNull Map<String, String> placeholders) {
        ArrayList<Component> components = new ArrayList<Component>(this.lines.size());
        List resolvers = this.resolvers.values().stream().flatMap(Collection::stream).toList();
        this.lines.forEach(line -> components.add(this.api.placeholders(audience, (String)line, placeholders, resolvers)));
        return components;
    }

    public Component asComponent(@Nullable Audience audience, @NotNull Map<String, String> placeholders) {
        return this.asComponents(audience, placeholders).getFirst();
    }

    public Component asComponent(@Nullable Audience audience) {
        return this.asComponents(audience, new HashMap<String, String>()).getFirst();
    }

    public List<Component> asComponents(@NotNull Map<String, String> placeholders) {
        return this.asComponents(null, placeholders);
    }

    public List<Component> asComponents() {
        return this.asComponents(null, new HashMap<String, String>());
    }

    public Component asComponent() {
        return this.asComponent(null);
    }

    public ComponentBuilder addClickResolver(String key, String value, @NotNull ClickEvent.Action action) {
        return this.addResolver(ResolverType.CLICK_EVENT, key, value, action);
    }

    public ComponentBuilder addPlaceholderResolver(String key, String value) {
        return this.addResolver(ResolverType.PLACEHOLDER, key, value, null);
    }

    public ComponentBuilder addHoverResolver(String key, String value) {
        return this.addResolver(ResolverType.HOVER_EVENT, key, value, null);
    }

    public ComponentBuilder addColorResolver(String key, String value) {
        return this.addResolver(ResolverType.TEXT_COLOR, key, value, null);
    }

    public ComponentBuilder addResolver(ResolverType type, String key, String value, @Nullable ClickEvent.Action action) {
        List resolvers = this.resolvers.getOrDefault((Object)type, new ArrayList());
        switch (type.ordinal()) {
            case 0: {
                resolvers.add(Placeholder.parsed((String)key.replaceAll("\\{", "").replaceAll("}", "").replaceAll("<", "").replaceAll(">", ""), (String)value));
                break;
            }
            case 3: {
                @NotNull Color color = ColorUtils.getColor(value);
                resolvers.add(Placeholder.styling((String)key, (StyleBuilderApplicable[])new StyleBuilderApplicable[]{TextColor.color((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue())}));
                break;
            }
            case 1: {
                if (action == null) {
                    throw new FusionException("The click action cannot be null!");
                }
                resolvers.add(Placeholder.styling((String)key, (StyleBuilderApplicable[])new StyleBuilderApplicable[]{ClickEvent.clickEvent((ClickEvent.Action)action, (String)value)}));
                break;
            }
            case 2: {
                @NotNull HoverEvent event = HoverEvent.showText((Component)AdvUtils.parse(value));
                // Could not load outer class - annotation placement on inner may be incorrect
                @NotNull TagResolver.Single placeholder = Placeholder.styling((String)key, (StyleBuilderApplicable[])new StyleBuilderApplicable[]{event});
                resolvers.add(placeholder);
            }
        }
        this.resolvers.put(type, resolvers);
        return this;
    }

    public ComponentBuilder addResolver(ResolverType type, TagResolver ... tags) {
        List resolvers = this.resolvers.getOrDefault((Object)type, new ArrayList());
        resolvers.addAll(Arrays.asList(tags));
        this.resolvers.put(type, resolvers);
        return this;
    }

    public ComponentBuilder removeResolver(ResolverType type) {
        this.resolvers.remove((Object)type);
        return this;
    }

    public ComponentBuilder addLine(String line) {
        this.lines.add(line);
        return this;
    }

    public ComponentBuilder removeLine(String line) {
        this.lines.remove(line);
        return this;
    }

    public static enum ResolverType {
        PLACEHOLDER,
        CLICK_EVENT,
        HOVER_EVENT,
        TEXT_COLOR,
        GENERIC_TYPE;

    }
}

