/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libs.com.ryderbelserion.fusion.api.configs.keys.ConfigKeys;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.paper.FusionPlugin;
import libs.com.ryderbelserion.fusion.paper.api.builder.gui.listeners.GuiListener;
import libs.com.ryderbelserion.fusion.paper.api.enums.Support;
import libs.com.ryderbelserion.fusion.paper.api.modules.EventRegistry;
import libs.com.ryderbelserion.fusion.paper.api.modules.ModuleLoader;
import libs.com.ryderbelserion.fusion.paper.api.structure.StructureRegistry;
import libs.com.ryderbelserion.fusion.paper.files.LegacyFileManager;
import libs.com.ryderbelserion.fusion.paper.files.config.PluginKeys;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionPaper
extends FusionCore {
    private boolean isRegistered = false;
    private HeadDatabaseAPI hdb = null;
    private LegacyFileManager fileManager = null;
    private StructureRegistry registry;
    private ModuleLoader loader;

    public FusionPaper(@NotNull ComponentLogger logger, @NotNull Path dataFolder) {
        super(logger, dataFolder);
    }

    public void enable(@NotNull Plugin plugin) {
        if (this.isRegistered) {
            return;
        }
        this.init(plugin.getName(), PluginKeys.class, ConfigKeys.class);
        FusionPlugin.setPlugin(plugin);
        this.registry = new StructureRegistry();
        if (this.fileManager == null) {
            this.fileManager = new LegacyFileManager();
        }
        if (Support.head_database.isEnabled()) {
            this.hdb = new HeadDatabaseAPI();
        }
        Server server = plugin.getServer();
        PluginManager manager = server.getPluginManager();
        this.loader = new ModuleLoader(new EventRegistry(plugin, server));
        manager.registerEvents((Listener)new GuiListener(), plugin);
        this.isRegistered = true;
    }

    public void bootstrap(@NotNull BootstrapContext context) {
        if (this.isRegistered) {
            return;
        }
        PluginMeta pluginMeta = context.getPluginMeta();
        this.init(pluginMeta.getName(), PluginKeys.class, ConfigKeys.class);
    }

    @NotNull
    public final LegacyFileManager getLegacyFileManager() {
        if (this.fileManager == null) {
            throw new FusionException("An error occurred while trying to get the legacy file manager instance.");
        }
        return this.fileManager;
    }

    @NotNull
    public final StructureRegistry getRegistry() {
        return this.registry;
    }

    @Nullable
    public final HeadDatabaseAPI getDatabaseAPI() {
        return this.hdb;
    }

    @NotNull
    public final ModuleLoader getLoader() {
        return this.loader;
    }

    @Override
    @NotNull
    public Component placeholders(@NotNull String line) {
        return this.placeholders(null, line, new HashMap<String, String>());
    }

    @Override
    @NotNull
    public Component placeholders(@NotNull String line, @NotNull Map<String, String> placeholders) {
        return this.placeholders(null, line, placeholders);
    }

    @Override
    @NotNull
    public Component placeholders(@Nullable Audience audience, @NotNull String line, @NotNull Map<String, String> placeholders) {
        return this.placeholders(null, line, placeholders, null);
    }

    @Override
    @NotNull
    public Component placeholders(@Nullable Audience audience, @NotNull String line, @NotNull Map<String, String> placeholders, @Nullable List<TagResolver> tags) {
        ArrayList<TagResolver> resolvers = new ArrayList<TagResolver>();
        if (tags != null) {
            resolvers.addAll(tags);
        }
        String clonedLine = line.replaceAll("\\{", "<").replaceAll("}", ">");
        placeholders.forEach((placeholder, value) -> {
            TagResolver.Single tag = Placeholder.parsed((String)placeholder.replaceAll("\\{", "").replaceAll("}", "").replaceAll("<", "").replaceAll(">", "").toLowerCase(), (String)value);
            resolvers.add((TagResolver)tag);
        });
        if (audience instanceof Player) {
            Player player = (Player)audience;
            if (Support.placeholder_api.isEnabled()) {
                clonedLine = PlaceholderAPI.setPlaceholders((Player)player, (String)clonedLine);
            }
        }
        return AdvUtils.parse(clonedLine, TagResolver.resolver(resolvers));
    }

    @Override
    @NotNull
    public Component color(@NotNull String line) {
        return this.color(null, line, new HashMap<String, String>());
    }

    @Override
    @NotNull
    public Component color(@NotNull String line, @NotNull Map<String, String> placeholders) {
        return this.color(null, line, placeholders);
    }

    @Override
    @NotNull
    public Component color(@Nullable Audience audience, @NotNull String line, @NotNull Map<String, String> placeholders) {
        return this.placeholders(audience, line, placeholders);
    }

    @Override
    public void sendMessage(@NotNull Audience audience, @NotNull String line, @NotNull Map<String, String> placeholders) {
        audience.sendMessage(this.color(audience, line, placeholders));
    }

    @Override
    public void sendMessage(@NotNull Audience audience, @NotNull List<String> lines, @NotNull Map<String, String> placeholders) {
        this.sendMessage(audience, libs.com.ryderbelserion.fusion.api.utils.StringUtils.toString(lines), placeholders);
    }

    @Override
    @NotNull
    public final String getItemsPlugin() {
        return this.config.getProperty(PluginKeys.items_plugin);
    }

    @Override
    @NotNull
    public final String chomp(@NotNull String message) {
        return StringUtils.chomp((String)message);
    }

    @Nullable
    public final HeadDatabaseAPI getHeadDatabaseAPI() {
        return this.hdb;
    }
}

