/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.api.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import libs.com.ryderbelserion.fusion.api.FusionApi;
import libs.com.ryderbelserion.fusion.api.interfaces.ILogger;
import libs.com.ryderbelserion.fusion.core.api.support.interfaces.IPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManager {
    private static final FusionApi api = FusionApi.Provider.get();
    private static final ILogger logger = api.getLogger();
    private static final boolean isVerbose = api.isVerbose();
    private static final Map<String, IPlugin> plugins = new HashMap<String, IPlugin>();

    public static void registerPlugin(@NotNull IPlugin plugin) {
        plugins.put(plugin.getName(), plugin.init());
    }

    @Nullable
    public static IPlugin getPlugin(@NotNull String name) {
        return plugins.get(name);
    }

    public static boolean isEnabled(@NotNull String name) {
        IPlugin plugin = PluginManager.getPlugin(name);
        return plugin != null && plugin.isEnabled();
    }

    public static void unregisterPlugin(@NotNull IPlugin plugin) {
        plugins.remove(plugin.getName());
        plugin.stop();
    }

    public static void printPlugins() {
        if (isVerbose) {
            PluginManager.getPlugins().forEach((name, plugin) -> {
                if (plugin.isEnabled() && !name.isEmpty()) {
                    logger.info("{}: FOUND", name);
                } else {
                    logger.info("{}: NOT FOUND", name);
                }
            });
        }
    }

    @NotNull
    public static Map<String, IPlugin> getPlugins() {
        return Collections.unmodifiableMap(plugins);
    }
}

