/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.api.builder;

import java.util.HashMap;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.utils.AdvUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentBuilder {
    private final FusionCore api = FusionCore.FusionProvider.get();
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TextComponent.Builder builder = Component.text();
    private final Audience target;
    private String value;

    public ComponentBuilder(@NotNull Audience target) {
        this.target = target;
    }

    @NotNull
    public ComponentBuilder append(@NotNull Component component) {
        this.builder.append(component);
        return this;
    }

    @NotNull
    public ComponentBuilder addHoverEvent(@NotNull String text) {
        if (!text.isEmpty()) {
            this.builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)AdvUtils.parse(text)));
        }
        return this;
    }

    @NotNull
    public ComponentBuilder addClickEvent(@Nullable ClickEvent.Action action, @NotNull String text) {
        if (action != null && !text.isEmpty()) {
            this.builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)action, (String)text));
        }
        return this;
    }

    @NotNull
    public TextComponent build() {
        if (this.value.isEmpty()) {
            return Component.empty();
        }
        return (TextComponent)((TextComponent.Builder)this.builder.append(this.api.color(this.target, this.value, new HashMap<String, String>()))).build();
    }

    public void send() {
        TextComponent component = this.build();
        if (!component.equals((Object)Component.empty())) {
            this.target.sendMessage((Component)component);
        }
    }

    @NotNull
    public Audience getTarget() {
        return this.target;
    }

    public void setValue(@NotNull String value) {
        if (!value.isEmpty()) {
            this.value = value;
        }
    }

    @NotNull
    public String getValue() {
        return this.value;
    }
}

