/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import libs.com.ryderbelserion.fusion.api.FusionApi;

public class StringUtils {
    private static final FusionApi api = FusionApi.Provider.get();

    public static String fromInteger(int number) {
        return NumberFormat.getIntegerInstance(Locale.US).format(number);
    }

    public static String fromDouble(double number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number);
    }

    public static Optional<Number> tryParseInt(String value) {
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    public static Optional<Boolean> tryParseBoolean(String value) {
        try {
            return Optional.of(Boolean.parseBoolean(value));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    public static String toString(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        for (String line : list) {
            message.append(line).append("\n");
        }
        return api.chomp(message.toString());
    }

    public static String format(double value) {
        DecimalFormat decimalFormat = new DecimalFormat(api.getNumberFormat());
        decimalFormat.setRoundingMode(StringUtils.mode());
        return decimalFormat.format(value);
    }

    public static RoundingMode mode() {
        return RoundingMode.valueOf(api.getRounding().toUpperCase());
    }
}

