/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import libs.com.ryderbelserion.fusion.api.FusionApi;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    private static final FusionApi api = FusionApi.Provider.get();
    private static final File dataFolder = api.getDataFolder().toFile();

    public static void extract(@NotNull String input, @NotNull Path output, boolean purge) {
        Path path;
        File key;
        if (!Files.exists(output, new LinkOption[0])) {
            File file = output.toFile();
            file.mkdirs();
        }
        if ((key = (path = Paths.get(output.resolve(input).toUri())).toFile()).exists()) {
            if (key.isDirectory()) {
                return;
            }
            return;
        }
        if (purge) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    @NotNull
                    public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attributes) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    @NotNull
                    public FileVisitResult postVisitDirectory(@NotNull Path directory, IOException exception) throws IOException {
                        Files.delete(directory);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HashSet<String> processedFiles = new HashSet<String>();
        try (JarFile jar = new JarFile(Path.of(FusionApi.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toFile());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                boolean isDirectory = entry.isDirectory();
                if (entryName.endsWith(".class") || entryName.startsWith("META-INF") || processedFiles.contains(entryName) || !entryName.startsWith(input)) continue;
                if (isDirectory) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    processedFiles.add(entryName);
                    continue;
                }
                if (entryName.contains("/")) {
                    String name = entryName.split("/")[1];
                    Path file = path.resolve(name);
                    if (!Files.exists(file, new LinkOption[0])) {
                        try (InputStream stream = jar.getInputStream(entry);){
                            Files.copy(stream, path.resolve(name), new CopyOption[0]);
                        }
                    }
                    processedFiles.add(entryName);
                    continue;
                }
                if (!Files.exists(path, new LinkOption[0])) {
                    try (InputStream stream = jar.getInputStream(entry);){
                        Files.copy(stream, path, new CopyOption[0]);
                    }
                }
                processedFiles.add(entryName);
            }
        }
        catch (IOException | URISyntaxException exception) {
            throw new FusionException(String.format("Failed to extract %s", input), exception);
        }
    }

    public static void download(@NotNull String link, @NotNull File directory) {
        CompletableFuture.runAsync(() -> {
            URL url;
            try {
                url = URI.create(link).toURL();
            }
            catch (MalformedURLException exception) {
                throw new FusionException("Failed to download because " + link + " is malformed", exception);
            }
            try (ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
                 FileOutputStream outputStream = new FileOutputStream(directory);){
                outputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            catch (IOException exception) {
                throw new FusionException("Failed to download " + link + " to " + directory.getAbsolutePath(), exception);
            }
        });
    }

    public static void write(@NotNull File input, @NotNull String format) {
        try (FileWriter writer = new FileWriter(input, true);
             BufferedWriter bufferedWriter = new BufferedWriter(writer);){
            bufferedWriter.write(format);
            bufferedWriter.newLine();
            writer.flush();
        }
        catch (Exception exception) {
            throw new FusionException("Failed to write " + String.valueOf(input) + " to " + String.valueOf(input), exception);
        }
    }

    public static void zip(@NotNull File input, boolean purge) {
        FileUtils.zip(List.of(input), null, "", purge);
    }

    public static void zip(@NotNull File input, @NotNull String extension, boolean purge) {
        List<File> files = FileUtils.getFiles(dataFolder, input.getName(), extension, false);
        if (files.isEmpty()) {
            return;
        }
        boolean hasNonEmptyFile = false;
        for (File zip : files) {
            if (!zip.exists() || zip.length() <= 0L) continue;
            hasNonEmptyFile = true;
            break;
        }
        if (!hasNonEmptyFile) {
            return;
        }
        int count = FileUtils.getFiles(input, ".gz", true).size();
        FileUtils.zip(files, input, "-" + ++count, purge);
    }

    public static void zip(@NotNull List<File> files, @Nullable File directory, String extra, boolean purge) {
        if (files.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        if (!builder.isEmpty()) {
            builder.append(extra);
        }
        builder.append(".gz");
        if (directory != null) {
            directory.mkdirs();
        }
        File zipFile = new File(directory == null ? dataFolder : directory, builder.toString());
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
             ZipOutputStream zipOut = new ZipOutputStream(fileOutputStream);){
            for (File file : files) {
                if (file.length() <= 0L) continue;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(file.getName());
                    zipOut.putNextEntry(zipEntry);
                    byte[] bytes = new byte[1024];
                    while ((length = fileInputStream.read(bytes)) >= 0) {
                        zipOut.write(bytes, 0, length);
                    }
                }
                if (!purge) continue;
                file.delete();
            }
        }
        catch (IOException exception) {
            throw new FusionException("Failed to zip " + String.valueOf(zipFile), exception);
        }
    }

    public static List<String> getNames(@NotNull File directory, @NotNull String folder, @NotNull String extension, boolean keepExtension) {
        return FileUtils.getFiles(directory, folder, extension, keepExtension).stream().map(File::getName).collect(Collectors.toList());
    }

    public static List<String> getNames(@NotNull File directory, @NotNull String extension, boolean keepExtension) {
        return FileUtils.getFiles(directory, extension, keepExtension).stream().map(File::getName).collect(Collectors.toList());
    }

    public static List<File> getFiles(@NotNull File directory, @NotNull String folder, @NotNull String extension, boolean keepExtension) {
        return FileUtils.getFiles(folder.isEmpty() ? directory : new File(directory, folder), extension, keepExtension);
    }

    public static List<File> getFiles(@NotNull File directory, @NotNull String extension, boolean keepExtension) {
        ArrayList<File> files = new ArrayList<File>();
        String[] list = directory.list();
        if (list == null) {
            return files;
        }
        File[] array = directory.listFiles();
        if (array == null) {
            return files;
        }
        for (File file : array) {
            if (file.isDirectory()) {
                String[] folder = file.list();
                if (folder == null) continue;
                for (String name : folder) {
                    if (!name.endsWith(extension)) continue;
                    files.add(new File(keepExtension ? name : name.replaceAll(extension, "")));
                }
                continue;
            }
            String name = file.getName();
            if (!name.endsWith(extension)) continue;
            files.add(new File(keepExtension ? name : name.replaceAll(extension, "")));
        }
        return Collections.unmodifiableList(files);
    }
}

