/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api.files.types.misc;

import java.io.File;
import java.io.IOException;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.api.files.CustomFile;
import libs.com.ryderbelserion.fusion.api.utils.FileUtils;
import org.jetbrains.annotations.NotNull;

public class LogCustomFile
extends CustomFile<LogCustomFile> {
    private final File directory;

    public LogCustomFile(@NotNull File file, @NotNull File directory, boolean isDynamic) {
        super(file, isDynamic);
        this.directory = directory;
    }

    public final LogCustomFile build() {
        if (!this.getFile().exists()) {
            try {
                this.getFile().createNewFile();
            }
            catch (IOException exception) {
                throw new FusionException("Could not create file " + String.valueOf(this.getFile()), exception);
            }
        }
        return this;
    }

    public final LogCustomFile load() {
        return this.save();
    }

    public final LogCustomFile save() {
        if (this.directory.exists()) {
            FileUtils.zip(this.directory, this.getType().getExtension(), true);
        }
        this.build();
        return this;
    }

    @Override
    public CustomFile<LogCustomFile> write(@NotNull String content) {
        super.write(content);
        FileUtils.write(this.getFile(), content);
        return this;
    }

    @Override
    public final FileType getType() {
        return FileType.LOG;
    }
}

