/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api.files.types;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.api.files.CustomFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.jackson.JacksonConfigurationLoader;

public class JsonCustomFile
extends CustomFile<JsonCustomFile> {
    private BasicConfigurationNode configurationNode;
    private final JacksonConfigurationLoader loader;

    public JsonCustomFile(@NotNull File file, boolean isDynamic, @Nullable UnaryOperator<ConfigurationOptions> options) {
        super(file, isDynamic);
        JacksonConfigurationLoader.Builder builder = JacksonConfigurationLoader.builder();
        if (options != null) {
            builder.defaultOptions(options);
        }
        this.loader = ((JacksonConfigurationLoader.Builder)builder.indent(2).file(file)).build();
    }

    public JsonCustomFile(@NotNull File file, boolean isDynamic) {
        this(file, isDynamic, null);
    }

    public final JsonCustomFile load() {
        if (this.getFile().isDirectory()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot load configuration, as {} is a directory.", (Object)this.getFileName());
            }
            return this;
        }
        this.configurationNode = CompletableFuture.supplyAsync(() -> {
            try {
                return (BasicConfigurationNode)this.loader.load();
            }
            catch (ConfigurateException exception) {
                throw new FusionException("Failed to load configuration file: " + this.getFileName(), exception);
            }
        }).join();
        return this;
    }

    public final JsonCustomFile save() {
        if (this.getFile().isDirectory()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot save configuration, as {} is a directory.", (Object)this.getFileName());
            }
            return this;
        }
        if (this.configurationNode == null) {
            if (this.isVerbose) {
                this.logger.severe("Configuration is null, cannot save {}!", (Object)this.getFileName());
            }
            return this;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.loader.save(this.configurationNode);
            }
            catch (ConfigurateException exception) {
                throw new FusionException("Failed to save configuration file: " + this.getFileName(), exception);
            }
        });
        return this;
    }

    @Override
    public final BasicConfigurationNode getBasicConfigurationNode() {
        return this.configurationNode;
    }

    @Override
    public final boolean isLoaded() {
        return this.configurationNode != null;
    }

    @Override
    public final FileType getType() {
        return FileType.YAML;
    }
}

