/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api.files.types;

import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerBuilder;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import java.io.File;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.api.files.CustomFile;
import org.jetbrains.annotations.NotNull;

public class JaluCustomFile
extends CustomFile<JaluCustomFile> {
    @NotNull
    private final Class<? extends SettingsHolder>[] holders;
    private SettingsManager settingsManager;
    private YamlFileResourceOptions options;
    private MigrationService service;

    @SafeVarargs
    public JaluCustomFile(@NotNull File file, Class<? extends SettingsHolder> ... holders) {
        super(file);
        this.holders = holders;
    }

    public final JaluCustomFile build() {
        SettingsManagerBuilder builder = SettingsManagerBuilder.withYamlFile(this.getFile(), this.options != null ? this.options : YamlFileResourceOptions.builder().indentationSize(2).build());
        if (this.service != null) {
            builder.migrationService(this.service);
        } else {
            builder.useDefaultMigrationService();
        }
        if (this.holders != null) {
            builder.configurationData(this.holders);
        }
        this.settingsManager = builder.create();
        return this;
    }

    public JaluCustomFile load() {
        if (this.settingsManager == null) {
            throw new FusionException("There was no settings manager available for " + this.getFile().getName());
        }
        this.settingsManager.reload();
        return this;
    }

    public JaluCustomFile save() {
        if (this.settingsManager == null) {
            throw new FusionException("There was no settings manager available for " + this.getFile().getName());
        }
        this.settingsManager.save();
        return this;
    }

    @Override
    public final boolean isLoaded() {
        return this.settingsManager != null;
    }

    @Override
    public FileType getType() {
        return FileType.JALU;
    }

    public final JaluCustomFile setOptions(@NotNull YamlFileResourceOptions options) {
        this.options = options;
        return this;
    }

    public final JaluCustomFile setService(@NotNull MigrationService service) {
        this.service = service;
        return this;
    }

    public final SettingsManager getSettingsManager() {
        return this.settingsManager;
    }
}

