/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api.files;

import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import libs.com.ryderbelserion.fusion.api.FusionApi;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.api.files.CustomFile;
import libs.com.ryderbelserion.fusion.api.files.types.JaluCustomFile;
import libs.com.ryderbelserion.fusion.api.files.types.JsonCustomFile;
import libs.com.ryderbelserion.fusion.api.files.types.YamlCustomFile;
import libs.com.ryderbelserion.fusion.api.files.types.misc.LogCustomFile;
import libs.com.ryderbelserion.fusion.api.files.types.misc.NbtCustomFile;
import libs.com.ryderbelserion.fusion.api.interfaces.ILogger;
import libs.com.ryderbelserion.fusion.api.utils.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationOptions;

public class FileManager {
    private final FusionApi api = FusionApi.Provider.get();
    private final ILogger logger = this.api.getLogger();
    private final boolean isVerbose = this.api.isVerbose();
    private final Path dataFolder = this.api.getDataFolder();
    private final Map<String, Map<String, CustomFile<? extends CustomFile<?>>>> customFiles = new HashMap();
    private final Map<String, FileType> folders = new HashMap<String, FileType>();
    private final String path;

    public FileManager(String path) {
        this.path = path;
    }

    public final FileManager init(boolean isReload) {
        this.dataFolder.toFile().mkdirs();
        this.customFiles.putIfAbsent(this.path, new HashMap());
        this.folders.forEach((folder, type) -> this.addFolder((String)folder, (FileType)((Object)type), null, isReload));
        return this;
    }

    public final FileManager addFolder(@NotNull String folder, @NotNull FileType fileType, @Nullable UnaryOperator<ConfigurationOptions> options, boolean isReload) {
        if (folder.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot add the folder as the folder is empty.");
            }
            return this;
        }
        if (!this.folders.containsKey(folder)) {
            this.folders.put(folder, fileType);
        }
        File directory = this.dataFolder.resolve(folder).toFile();
        FileUtils.extract(directory.getName(), this.dataFolder, false);
        File[] contents = directory.listFiles();
        if (contents == null) {
            return this;
        }
        String extension = fileType.getExtension();
        for (File file : contents) {
            if (file.isDirectory()) {
                String[] layers = file.list();
                if (layers == null) continue;
                for (String layer : layers) {
                    if (fileType != FileType.NONE && !layer.endsWith(extension)) continue;
                    this.addFile(layer, folder + File.separator + file.getName(), fileType, options, true, isReload);
                }
                continue;
            }
            String fileName = file.getName();
            if (fileType != FileType.NONE && !fileName.endsWith(extension)) continue;
            this.addFile(fileName, folder, fileType, options, true, isReload);
        }
        return this;
    }

    @SafeVarargs
    public final FileManager addFolder(@NotNull String folder, @Nullable MigrationService service, @Nullable YamlFileResourceOptions options, boolean isReload, Class<? extends SettingsHolder> ... holders) {
        if (folder.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot add the folder as the folder is empty.");
            }
            return this;
        }
        File directory = this.dataFolder.resolve(folder).toFile();
        FileUtils.extract(directory.getName(), this.dataFolder, false);
        File[] contents = directory.listFiles();
        if (contents == null) {
            return this;
        }
        for (File file : contents) {
            if (file.isDirectory()) {
                String[] layers = file.list();
                if (layers == null) continue;
                for (String layer : layers) {
                    if (!layer.endsWith(".yml")) continue;
                    this.addFile(layer, folder, service, options, isReload, holders);
                }
                continue;
            }
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            this.addFile(fileName, folder, service, options, isReload, holders);
        }
        return this;
    }

    @SafeVarargs
    public final FileManager addFile(@NotNull String fileName, @Nullable String folder, @Nullable MigrationService service, @Nullable YamlFileResourceOptions options, boolean isReload, Class<? extends SettingsHolder> ... holders) {
        String path = this.getPath(folder);
        Map customFiles = this.customFiles.getOrDefault(path, new HashMap());
        if (customFiles.containsKey(fileName) && !isReload) {
            ((CustomFile)customFiles.get(fileName)).load();
            return this;
        }
        File file = this.dataFolder.resolve((String)(folder != null ? folder + File.separator + fileName : fileName)).toFile();
        JaluCustomFile jalu = new JaluCustomFile(file, holders);
        if (service != null) {
            jalu.setService(service);
        }
        if (options != null) {
            jalu.setOptions(options);
        }
        customFiles.putIfAbsent(fileName, jalu.build());
        this.customFiles.putIfAbsent(path, customFiles);
        return this;
    }

    @SafeVarargs
    public final FileManager addFile(@NotNull String fileName, @Nullable MigrationService service, @Nullable YamlFileResourceOptions options, Class<? extends SettingsHolder> ... holders) {
        return this.addFile(fileName, null, service, options, false, holders);
    }

    public final FileManager addFile(@NotNull String fileName, @NotNull String folder, @NotNull FileType fileType, boolean isReload) {
        return this.addFile(fileName, folder, fileType, null, isReload, false);
    }

    public final FileManager addFile(@NotNull String fileName, @NotNull String folder, @NotNull FileType fileType) {
        return this.addFile(fileName, folder, fileType, null, false, false);
    }

    public final FileManager addFile(@NotNull String fileName, @Nullable String folder, @NotNull FileType fileType, @Nullable UnaryOperator<ConfigurationOptions> defaultOptions, boolean isDynamic, boolean isReload) {
        if (fileName.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot add the file as the file is null or empty.");
            }
            return this;
        }
        File file = this.dataFolder.resolve((String)(folder != null ? folder + File.separator + fileName : fileName)).toFile();
        if (!file.exists()) {
            FileUtils.extract(file.getName(), file.getParentFile().toPath(), false);
        }
        String extension = fileType.getExtension();
        switch (fileType) {
            case YAML: {
                String path = this.getPath(folder);
                Map customFiles = this.customFiles.getOrDefault(path, new HashMap());
                if (customFiles.containsKey(fileName) && !isReload) {
                    ((CustomFile)customFiles.get(fileName)).load();
                    return this;
                }
                customFiles.putIfAbsent(fileName, new YamlCustomFile(file, isDynamic, defaultOptions).load());
                this.customFiles.putIfAbsent(path, customFiles);
                break;
            }
            case JSON: {
                String path = this.getPath(folder);
                Map customFiles = this.customFiles.getOrDefault(path, new HashMap());
                if (customFiles.containsKey(fileName) && !isReload) {
                    ((CustomFile)customFiles.get(fileName)).load();
                    return this;
                }
                customFiles.putIfAbsent(fileName, new JsonCustomFile(file, isDynamic, defaultOptions).load());
                this.customFiles.putIfAbsent(path, customFiles);
                break;
            }
            case NBT: {
                String path = this.getPath(folder);
                Map customFiles = this.customFiles.getOrDefault(path, new HashMap());
                if (customFiles.containsKey(fileName)) {
                    throw new FusionException("The file " + fileName + " already exists.");
                }
                customFiles.putIfAbsent(fileName, new NbtCustomFile(file, isDynamic));
                this.customFiles.putIfAbsent(path, customFiles);
                break;
            }
            case LOG: {
                String path = this.getPath(folder);
                Map customFiles = this.customFiles.getOrDefault(path, new HashMap());
                if (customFiles.containsKey(fileName)) {
                    throw new FusionException("The file " + fileName + " already exists.");
                }
                if (folder == null) {
                    throw new FusionException("You must specify a folder for the " + extension + " file.");
                }
                customFiles.putIfAbsent(fileName, new NbtCustomFile(file, isDynamic));
                this.customFiles.putIfAbsent(path, customFiles);
                break;
            }
        }
        return this;
    }

    public final FileManager addFile(@NotNull String fileName, @NotNull FileType fileType, @Nullable UnaryOperator<ConfigurationOptions> options) {
        return this.addFile(fileName, null, fileType, options, false, false);
    }

    public final FileManager addFile(@NotNull String fileName, @NotNull FileType fileType) {
        return this.addFile(fileName, fileType, null);
    }

    public final FileManager addFile(@NotNull String fileName) {
        FileType fileType = FileType.NONE;
        if (fileName.endsWith(".yml")) {
            fileType = FileType.YAML;
        } else if (fileName.endsWith(".json")) {
            fileType = FileType.JSON;
        } else if (fileName.endsWith(".nbt")) {
            fileType = FileType.NBT;
        } else if (fileName.endsWith(".log")) {
            fileType = FileType.LOG;
        }
        return this.addFile(fileName, null, fileType, null, false, false);
    }

    public final FileManager saveFile(@NotNull String folder, @NotNull String fileName) {
        FileType fileType = FileType.NONE;
        if (fileName.endsWith(".yml")) {
            fileType = FileType.YAML;
        } else if (fileName.endsWith(".json")) {
            fileType = FileType.JSON;
        } else if (fileName.endsWith(".nbt")) {
            fileType = FileType.NBT;
        } else if (fileName.endsWith(".log")) {
            fileType = FileType.LOG;
        }
        return this.saveFile(folder, fileName, fileType);
    }

    public final FileManager saveFile(@NotNull String fileName) {
        return this.saveFile("", fileName);
    }

    public final FileManager saveFile(@NotNull String folder, @NotNull String fileName, @NotNull FileType fileType) {
        if (fileName.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot save the file as the file is null or empty.");
            }
            return this;
        }
        String path = this.getPath(folder.isBlank() ? null : folder);
        Map customFiles = this.customFiles.getOrDefault(path, new HashMap());
        if (!customFiles.containsKey(fileName)) {
            if (this.isVerbose) {
                this.logger.warn("Cannot write to file as the file does not exist.");
            }
            return this;
        }
        if (fileType == FileType.LOG) {
            throw new FusionException("You must use FileManager#writeFile since the FileType is set to LOG");
        }
        ((CustomFile)customFiles.get(fileName)).save();
        return this;
    }

    public final FileManager writeFile(@NotNull String folder, @NotNull String fileName, @NotNull FileType fileType, @NotNull String content) {
        if (fileType != FileType.LOG) {
            throw new FusionException("The file " + fileName + " is not a log file.");
        }
        if (fileName.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot write to the file as the file is null or empty.");
            }
            return this;
        }
        String path = this.getPath(folder.isBlank() ? null : folder);
        Map customFiles = this.customFiles.getOrDefault(path, new HashMap());
        if (!customFiles.containsKey(fileName)) {
            if (this.isVerbose) {
                this.logger.warn("Cannot write to file as the file does not exist.");
            }
            return this;
        }
        ((CustomFile)customFiles.get(fileName)).write(content);
        return this;
    }

    public final FileManager removeFile(@NotNull String folder, @NotNull String fileName, boolean purge) {
        if (fileName.isBlank()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot remove the file as the file is null or empty.");
            }
            return this;
        }
        String path = this.getPath(folder.isBlank() ? null : folder);
        Map customFiles = this.customFiles.getOrDefault(path, new HashMap());
        if (!customFiles.containsKey(fileName)) {
            return this;
        }
        CustomFile file = (CustomFile)customFiles.remove(fileName);
        if (purge) {
            file.delete();
            return this;
        }
        file.save();
        return this;
    }

    public final FileManager removeFile(CustomFile<? extends CustomFile<?>> customFile, boolean purge) {
        return this.removeFile(customFile.getFile().getPath() + File.separator, customFile.getFileName(), purge);
    }

    public final FileManager reload() {
        return this.handle(false);
    }

    public final FileManager save() {
        return this.handle(true);
    }

    public final FileManager purge() {
        this.customFiles.clear();
        return this;
    }

    public final FileManager extractResource(@NotNull String input, @NotNull String output, boolean purge) {
        FileUtils.extract(input, this.dataFolder.resolve(output), purge);
        return this;
    }

    public final FileManager extractFolder(@NotNull String folder) {
        FileUtils.extract(folder, this.dataFolder, false);
        return this;
    }

    public final FileManager extractFile(@NotNull String name) {
        FileUtils.extract(name, this.dataFolder, false);
        return this;
    }

    private FileManager handle(boolean toggle) {
        if (this.customFiles.isEmpty()) {
            return this;
        }
        HashMap<String, File> brokenFiles = new HashMap<String, File>();
        for (Map.Entry<String, Map<String, CustomFile<CustomFile<?>>>> outer : this.customFiles.entrySet()) {
            String folder2 = outer.getKey();
            Map<String, CustomFile<CustomFile<?>>> files = outer.getValue();
            for (Map.Entry<String, CustomFile<CustomFile<?>>> inner : files.entrySet()) {
                CustomFile<CustomFile<?>> customFile = inner.getValue();
                File file2 = customFile.getFile();
                if (!file2.exists()) {
                    brokenFiles.put(folder2, file2);
                    continue;
                }
                if (toggle) {
                    customFile.save();
                    continue;
                }
                customFile.load();
            }
        }
        if (!brokenFiles.isEmpty()) {
            brokenFiles.forEach((folder, file) -> {
                Map<String, CustomFile<CustomFile<?>>> files = this.customFiles.get(folder);
                String fileName = file.getName();
                files.remove(fileName);
            });
        }
        return this;
    }

    public String getPath(String folder) {
        return folder != null ? this.path + File.separator + folder : this.path;
    }

    @NotNull
    public final Map<String, CustomFile<? extends CustomFile<?>>> getCustomFiles(@Nullable String folder) {
        return this.getCustomFiles().getOrDefault(this.getPath(folder), new HashMap());
    }

    @Nullable
    public final CustomFile<? extends CustomFile<?>> getCustomFile(String folder, String file) {
        return this.getCustomFiles(folder).getOrDefault(file, null);
    }

    @Nullable
    public final CustomFile<? extends CustomFile<?>> getCustomFile(String file) {
        return this.getCustomFiles(null).getOrDefault(file, null);
    }

    @Nullable
    public YamlCustomFile getYamlFile(String fileName) {
        return (YamlCustomFile)this.getCustomFile(fileName);
    }

    @Nullable
    public JsonCustomFile getJsonFile(String fileName) {
        return (JsonCustomFile)this.getCustomFile(fileName);
    }

    @Nullable
    public JaluCustomFile getJaluFile(String fileName) {
        return (JaluCustomFile)this.getCustomFile(fileName);
    }

    @Nullable
    public LogCustomFile getLogFile(String fileName) {
        return (LogCustomFile)this.getCustomFile(fileName);
    }

    public Map<String, Map<String, CustomFile<? extends CustomFile<?>>>> getCustomFiles() {
        return Collections.unmodifiableMap(this.customFiles);
    }
}

