/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api.files;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import libs.com.ryderbelserion.fusion.api.FusionApi;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.api.interfaces.ILogger;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public abstract class CustomFile<T extends CustomFile<T>> {
    private final FusionApi api = FusionApi.Provider.get();
    protected final ILogger logger = this.api.getLogger();
    protected final boolean isVerbose = this.api.isVerbose();
    private final boolean isDynamic;
    private final File file;

    public CustomFile(@NotNull File file, boolean isDynamic) {
        this.isDynamic = isDynamic;
        this.file = file;
    }

    public CustomFile(@NotNull File file) {
        this.isDynamic = false;
        this.file = file;
    }

    public CustomFile<T> build() {
        return this;
    }

    public abstract CustomFile<T> load();

    public abstract CustomFile<T> save();

    public CustomFile<T> write(@NotNull String content) {
        if (this.getType() != FileType.LOG) {
            throw new FusionException("This file is not a log file");
        }
        return this;
    }

    public String getStringValueWithDefault(String defaultValue, Object ... path) {
        return switch (this.getType()) {
            case FileType.JSON -> ((BasicConfigurationNode)this.getBasicConfigurationNode().node(path)).getString(defaultValue);
            case FileType.YAML -> ((CommentedConfigurationNode)this.getConfigurationNode().node(path)).getString(defaultValue);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getType()));
        };
    }

    public String getStringValue(Object ... path) {
        return this.getStringValueWithDefault("", path);
    }

    public boolean getBooleanValueWithDefault(boolean defaultValue, Object ... path) {
        return switch (this.getType()) {
            case FileType.JSON -> ((BasicConfigurationNode)this.getBasicConfigurationNode().node(path)).getBoolean(defaultValue);
            case FileType.YAML -> ((CommentedConfigurationNode)this.getConfigurationNode().node(path)).getBoolean(defaultValue);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getType()));
        };
    }

    public boolean getBooleanValue(Object ... path) {
        return this.getBooleanValueWithDefault(false, path);
    }

    public double getDoubleValueWithDefault(double defaultValue, Object ... path) {
        return switch (this.getType()) {
            case FileType.JSON -> ((BasicConfigurationNode)this.getBasicConfigurationNode().node(path)).getDouble(defaultValue);
            case FileType.YAML -> ((CommentedConfigurationNode)this.getConfigurationNode().node(path)).getDouble(defaultValue);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getType()));
        };
    }

    public double getDoubleValue(Object ... path) {
        return this.getDoubleValueWithDefault(0.0, path);
    }

    public long getLongValueWithDefault(long defaultValue, Object ... path) {
        return switch (this.getType()) {
            case FileType.JSON -> ((BasicConfigurationNode)this.getBasicConfigurationNode().node(path)).getLong(defaultValue);
            case FileType.YAML -> ((CommentedConfigurationNode)this.getConfigurationNode().node(path)).getLong(defaultValue);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getType()));
        };
    }

    public long getLongValue(Object ... path) {
        return this.getLongValueWithDefault(0L, path);
    }

    public int getIntValueWithDefault(int defaultValue, Object ... path) {
        return switch (this.getType()) {
            case FileType.JSON -> ((BasicConfigurationNode)this.getBasicConfigurationNode().node(path)).getInt(defaultValue);
            case FileType.YAML -> ((CommentedConfigurationNode)this.getConfigurationNode().node(path)).getInt(defaultValue);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getType()));
        };
    }

    public int getIntValue(Object ... path) {
        return this.getIntValueWithDefault(0, path);
    }

    public List<String> getStringList(Object ... path) {
        List<String> list;
        switch (this.getType()) {
            case JSON: {
                try {
                    List<String> list2;
                    list = list2 = ((BasicConfigurationNode)this.getBasicConfigurationNode().node(path)).getList(String.class);
                    break;
                }
                catch (SerializationException exception) {
                    throw new FusionException("Failed to serialize " + Arrays.toString(path), exception);
                }
            }
            case YAML: {
                try {
                    List<String> list3 = ((CommentedConfigurationNode)this.getConfigurationNode().node(path)).getList(String.class);
                    list = list3;
                    break;
                }
                catch (SerializationException exception) {
                    throw new FusionException("Failed to serialize " + Arrays.toString(path), exception);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getType()));
            }
        }
        return list;
    }

    public CommentedConfigurationNode getConfigurationNode() {
        return null;
    }

    public BasicConfigurationNode getBasicConfigurationNode() {
        return null;
    }

    public CustomFile<T> delete() {
        File file = this.getFile();
        if (file != null && file.exists() && file.delete() && this.isVerbose) {
            this.logger.warn("Successfully deleted {}", (Object)this.getFileName());
        }
        return this;
    }

    public CustomFile<T> getInstance() {
        return this;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public FileType getType() {
        return FileType.NONE;
    }

    public boolean isLoaded() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }
}

