/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api.configs;

import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerBuilder;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import java.nio.file.Path;
import libs.com.ryderbelserion.fusion.api.exceptions.FusionException;

public class ConfigManager {
    private final Path dataFolder;
    private SettingsManager config;

    public ConfigManager(Path dataFolder) {
        this.dataFolder = dataFolder;
    }

    @SafeVarargs
    public final void init(Class<? extends SettingsHolder> ... classes) {
        YamlFileResourceOptions builder = YamlFileResourceOptions.builder().indentationSize(2).build();
        this.config = SettingsManagerBuilder.withYamlFile(this.dataFolder.resolve("fusion.yml"), builder).useDefaultMigrationService().configurationData(classes).create();
    }

    public void reload() {
        if (this.config == null) {
            throw new FusionException("fusion.yml is not available.");
        }
        this.config.reload();
    }

    public final SettingsManager getConfig() {
        return this.config;
    }
}

