/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.api;

import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.SettingsManager;
import java.nio.file.Path;
import libs.com.ryderbelserion.fusion.api.configs.ConfigManager;
import libs.com.ryderbelserion.fusion.api.configs.keys.ConfigKeys;
import libs.com.ryderbelserion.fusion.api.files.FileManager;
import libs.com.ryderbelserion.fusion.api.interfaces.ILogger;

public abstract class FusionApi {
    private ConfigManager configManager;
    private FileManager fileManager;
    protected SettingsManager config;

    public abstract Path getDataFolder();

    public abstract ILogger getLogger();

    public abstract String chomp(String var1);

    public String getNumberFormat() {
        return this.config.getProperty(ConfigKeys.number_format);
    }

    public String getRounding() {
        return this.config.getProperty(ConfigKeys.rounding);
    }

    public boolean isVerbose() {
        return this.config.getProperty(ConfigKeys.is_verbose);
    }

    public void init(String path, Class<? extends SettingsHolder> ... classes) {
        this.configManager = new ConfigManager(this.getDataFolder());
        this.configManager.init(classes);
        this.config = this.configManager.getConfig();
        this.fileManager = new FileManager(path);
    }

    public void save() {
    }

    public void reload() {
        this.configManager.reload();
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public static class Provider {
        private static FusionApi core = null;

        public static void register(FusionApi core) {
            Provider.core = core;
        }

        public static FusionApi get() {
            return core;
        }
    }
}

