/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.suggestion;

import dev.triumphteam.cmd.core.extention.registry.Registry;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import dev.triumphteam.cmd.core.util.Pair;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuggestionRegistry<S>
implements Registry {
    private final Map<SuggestionKey, Pair<SuggestionResolver<S>, SuggestionMethod>> suggestions = new HashMap<SuggestionKey, Pair<SuggestionResolver<S>, SuggestionMethod>>();
    private final Map<Class<?>, Pair<SuggestionResolver<S>, SuggestionMethod>> typeSuggestions = new HashMap();

    public void register(@NotNull SuggestionKey key, @NotNull SuggestionResolver<S> resolver, @NotNull SuggestionMethod method) {
        this.suggestions.put(key, new Pair<SuggestionResolver<S>, SuggestionMethod>(resolver, method));
    }

    public void register(@NotNull Class<?> type, @NotNull SuggestionResolver<S> resolver, @NotNull SuggestionMethod method) {
        this.typeSuggestions.put(type, new Pair<SuggestionResolver<S>, SuggestionMethod>(resolver, method));
    }

    @Contract(value="null -> null")
    @Nullable
    public Pair<SuggestionResolver<S>, SuggestionMethod> getSuggestionResolver(@Nullable SuggestionKey key) {
        if (key == null) {
            return null;
        }
        return this.suggestions.get(key);
    }

    @Nullable
    public Pair<SuggestionResolver<S>, SuggestionMethod> getSuggestionResolver(@NotNull Class<?> type) {
        return this.typeSuggestions.get(type);
    }
}

