/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.suggestion;

import dev.triumphteam.cmd.core.suggestion.Suggestion;
import dev.triumphteam.cmd.core.util.EnumUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumSuggestion<S>
implements Suggestion<S> {
    private final Class<? extends Enum<?>> enumType;
    private final boolean suggestLowercase;

    public EnumSuggestion(@NotNull Class<? extends Enum<?>> enumType, boolean suggestLowercase) {
        this.enumType = enumType;
        this.suggestLowercase = suggestLowercase;
        EnumUtils.populateCache(enumType);
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull S sender, @NotNull String current, @NotNull List<String> arguments) {
        return EnumUtils.getEnumConstants(this.enumType).values().stream().map(it -> {
            Enum constant = (Enum)it.get();
            if (constant == null) {
                return null;
            }
            String name = constant.name();
            return this.suggestLowercase ? name.toLowerCase() : name;
        }).filter(Objects::nonNull).filter(it -> it.toLowerCase().startsWith(current.toLowerCase())).collect(Collectors.toList());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumSuggestion that = (EnumSuggestion)o;
        return this.enumType.equals(that.enumType);
    }

    public int hashCode() {
        return Objects.hash(this.enumType);
    }

    @NotNull
    public String toString() {
        return "EnumSuggestion{enumType=" + this.enumType + '}';
    }
}

