/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.processor;

import dev.triumphteam.cmd.core.annotations.ArgDescriptions;
import dev.triumphteam.cmd.core.annotations.CommandFlags;
import dev.triumphteam.cmd.core.annotations.NamedArguments;
import dev.triumphteam.cmd.core.annotations.Suggestions;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.keyed.Argument;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentKey;
import dev.triumphteam.cmd.core.argument.keyed.Flag;
import dev.triumphteam.cmd.core.argument.keyed.FlagKey;
import dev.triumphteam.cmd.core.extention.CommandOptions;
import dev.triumphteam.cmd.core.extention.ValidationResult;
import dev.triumphteam.cmd.core.extention.annotation.ProcessorTarget;
import dev.triumphteam.cmd.core.extention.command.Settings;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.extention.meta.MetaKey;
import dev.triumphteam.cmd.core.extention.registry.FlagRegistry;
import dev.triumphteam.cmd.core.extention.registry.NamedArgumentRegistry;
import dev.triumphteam.cmd.core.extention.registry.RegistryContainer;
import dev.triumphteam.cmd.core.processor.AbstractCommandProcessor;
import dev.triumphteam.cmd.core.suggestion.EmptySuggestion;
import dev.triumphteam.cmd.core.suggestion.Suggestion;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class SubCommandProcessor<D, S>
extends AbstractCommandProcessor<D, S> {
    private final Method method;
    private final NamedArgumentRegistry namedArgumentRegistry;
    private final FlagRegistry flagRegistry;

    SubCommandProcessor(@NotNull Object invocationInstance, @NotNull Method method, @NotNull RegistryContainer<D, S> registryContainer, @NotNull CommandOptions<D, S> commandOptions, @NotNull CommandMeta parentMeta) {
        super(invocationInstance, method, registryContainer, commandOptions, parentMeta);
        this.method = method;
        this.namedArgumentRegistry = registryContainer.getNamedArgumentRegistry();
        this.flagRegistry = registryContainer.getFlagRegistry();
    }

    @Override
    @NotNull
    public AnnotatedElement getAnnotatedElement() {
        return this.method;
    }

    @Override
    @NotNull
    public CommandMeta createMeta(@NotNull Settings.Builder<D, S> settingsBuilder) {
        CommandMeta.Builder meta = new CommandMeta.Builder(this.getParentMeta());
        meta.add(MetaKey.NAME, this.getName());
        meta.add(MetaKey.DESCRIPTION, this.getDescription());
        this.processAnnotations(this.getCommandOptions().getCommandExtensions(), this.method, ProcessorTarget.COMMAND, meta);
        this.processCommandMeta(this.getCommandOptions().getCommandExtensions(), this.method, ProcessorTarget.COMMAND, meta, settingsBuilder);
        return meta.build();
    }

    @NotNull
    public Class<? extends S> senderType() {
        Parameter[] parameters = this.method.getParameters();
        if (parameters.length == 0) {
            throw this.createException("Sender parameter missing");
        }
        Class<?> type = parameters[0].getType();
        Set allowedSenders = this.getCommandOptions().getCommandExtensions().getSenderExtension().getAllowedSenders();
        if (!allowedSenders.contains(type)) {
            throw this.createException("\"" + type.getSimpleName() + "\" is not a valid sender. Sender must be one of the following: " + allowedSenders.stream().map(it -> "\"" + it.getSimpleName() + "\"").collect(Collectors.joining(", ")));
        }
        return type;
    }

    @NotNull
    public List<InternalArgument<S, ?>> arguments(@NotNull CommandMeta parentMeta) {
        Parameter[] parameters = this.method.getParameters();
        HashMap<Parameter, CommandMeta> parameterMetas = new HashMap<Parameter, CommandMeta>();
        for (Parameter parameter : parameters) {
            CommandMeta.Builder meta = new CommandMeta.Builder(parentMeta);
            this.processAnnotations(this.getCommandOptions().getCommandExtensions(), parameter, ProcessorTarget.ARGUMENT, meta);
            parameterMetas.put(parameter, meta.build());
        }
        if (parameters.length <= 1) {
            return Collections.emptyList();
        }
        List<String> argDescriptions = this.argDescriptionFromMethodAnnotation();
        Map<Integer, Suggestion<S>> suggestions = this.suggestionsFromMethodAnnotation();
        ArgumentGroup<Flag> flagGroup = this.flagGroupFromMethod(this.method);
        ArgumentGroup<Argument> argumentGroup = this.argumentGroupFromMethod(this.method);
        int last = parameters.length - 1;
        ArrayList arguments = new ArrayList();
        for (int i = 1; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            CommandMeta meta = (CommandMeta)parameterMetas.get(parameter);
            if (meta == null) {
                throw this.createException("An error occurred while getting parameter meta data for parameter " + parameter.getName());
            }
            InternalArgument<S, ?> argument = this.argumentFromParameter(meta, parameter, argDescriptions, suggestions, flagGroup, argumentGroup, i);
            ValidationResult<String> result = this.getCommandOptions().getCommandExtensions().getArgumentValidator().validate(meta, argument, i, last);
            if (result instanceof ValidationResult.Invalid) {
                throw this.createException((String)((ValidationResult.Invalid)result).getMessage());
            }
            if (result instanceof ValidationResult.Ignore) continue;
            arguments.add(argument);
        }
        return arguments;
    }

    @NotNull
    private ArgumentGroup<Argument> argumentGroupFromMethod(@NotNull Method method) {
        NamedArguments namedAnnotation = method.getAnnotation(NamedArguments.class);
        if (namedAnnotation == null) {
            return ArgumentGroup.named(Collections.emptyList());
        }
        List<Argument> argumentsFromRegistry = this.namedArgumentRegistry.getArguments(ArgumentKey.of(namedAnnotation.value()));
        if (argumentsFromRegistry == null) {
            return ArgumentGroup.named(Collections.emptyList());
        }
        return ArgumentGroup.named(argumentsFromRegistry);
    }

    @NotNull
    private ArgumentGroup<Flag> flagGroupFromMethod(@NotNull Method method) {
        CommandFlags flagsAnnotation = method.getAnnotation(CommandFlags.class);
        if (flagsAnnotation != null) {
            List<Flag> flagsFromRegistry;
            String key = flagsAnnotation.key();
            if (!key.isEmpty() && (flagsFromRegistry = this.flagRegistry.getFlags(FlagKey.of(key))) != null) {
                return ArgumentGroup.flags(flagsFromRegistry);
            }
            List<Flag> flags = this.flagsFromRawFlags(Arrays.asList(flagsAnnotation.value()));
            return ArgumentGroup.flags(flags);
        }
        dev.triumphteam.cmd.core.annotations.Flag flagAnnotation = method.getAnnotation(dev.triumphteam.cmd.core.annotations.Flag.class);
        if (flagAnnotation == null) {
            return ArgumentGroup.flags(Collections.emptyList());
        }
        List<Flag> flags = this.flagsFromRawFlags(Collections.singletonList(flagAnnotation));
        return ArgumentGroup.flags(flags);
    }

    @NotNull
    private List<Flag> flagsFromRawFlags(@NotNull List<dev.triumphteam.cmd.core.annotations.Flag> rawFlags) {
        return rawFlags.stream().map(it -> Flag.flag(it.flag()).longFlag(it.longFlag()).argument(it.argument()).description(it.description()).suggestion(SuggestionKey.of(it.suggestion())).build()).collect(Collectors.toList());
    }

    @NotNull
    private List<String> argDescriptionFromMethodAnnotation() {
        ArgDescriptions argDescriptions = this.method.getAnnotation(ArgDescriptions.class);
        if (argDescriptions == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(argDescriptions.value());
    }

    @NotNull
    public Map<Integer, Suggestion<S>> suggestionsFromMethodAnnotation() {
        HashMap<Integer, Suggestion<S>> map = new HashMap<Integer, Suggestion<S>>();
        List<dev.triumphteam.cmd.core.annotations.Suggestion> suggestionsFromAnnotations = this.getSuggestionsFromAnnotations();
        for (int i = 0; i < suggestionsFromAnnotations.size(); ++i) {
            dev.triumphteam.cmd.core.annotations.Suggestion suggestion = suggestionsFromAnnotations.get(i);
            String key = suggestion.value();
            if (key.isEmpty()) {
                map.put(i, new EmptySuggestion());
                continue;
            }
            map.put(i, this.createSuggestion(SuggestionKey.of(key), Void.TYPE));
        }
        return map;
    }

    @NotNull
    private @NotNull List<@NotNull dev.triumphteam.cmd.core.annotations.Suggestion> getSuggestionsFromAnnotations() {
        Suggestions requirements = this.method.getAnnotation(Suggestions.class);
        if (requirements != null) {
            return Arrays.asList(requirements.value());
        }
        dev.triumphteam.cmd.core.annotations.Suggestion suggestion = this.method.getAnnotation(dev.triumphteam.cmd.core.annotations.Suggestion.class);
        if (suggestion == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(suggestion);
    }
}

