/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.processor;

import com.google.common.base.CaseFormat;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Description;
import dev.triumphteam.cmd.core.annotations.Join;
import dev.triumphteam.cmd.core.annotations.Optional;
import dev.triumphteam.cmd.core.annotations.Split;
import dev.triumphteam.cmd.core.annotations.Syntax;
import dev.triumphteam.cmd.core.argument.ArgumentResolver;
import dev.triumphteam.cmd.core.argument.CollectionInternalArgument;
import dev.triumphteam.cmd.core.argument.EnumInternalArgument;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.JoinedStringInternalArgument;
import dev.triumphteam.cmd.core.argument.ResolverInternalArgument;
import dev.triumphteam.cmd.core.argument.SplitStringInternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.argument.UnknownInternalArgument;
import dev.triumphteam.cmd.core.argument.keyed.Argument;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import dev.triumphteam.cmd.core.argument.keyed.Arguments;
import dev.triumphteam.cmd.core.argument.keyed.Flag;
import dev.triumphteam.cmd.core.argument.keyed.Flags;
import dev.triumphteam.cmd.core.argument.keyed.Keyed;
import dev.triumphteam.cmd.core.argument.keyed.KeyedInternalArgument;
import dev.triumphteam.cmd.core.argument.keyed.ListArgument;
import dev.triumphteam.cmd.core.exceptions.SubCommandRegistrationException;
import dev.triumphteam.cmd.core.extention.CommandOptions;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.extention.registry.ArgumentRegistry;
import dev.triumphteam.cmd.core.extention.registry.RegistryContainer;
import dev.triumphteam.cmd.core.processor.CommandProcessor;
import dev.triumphteam.cmd.core.suggestion.EmptySuggestion;
import dev.triumphteam.cmd.core.suggestion.EnumSuggestion;
import dev.triumphteam.cmd.core.suggestion.SimpleSuggestion;
import dev.triumphteam.cmd.core.suggestion.Suggestion;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import dev.triumphteam.cmd.core.suggestion.SuggestionRegistry;
import dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import dev.triumphteam.cmd.core.util.Pair;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCommandProcessor<D, S>
implements CommandProcessor<D, S> {
    private static final Set<Class<?>> SUPPORTED_COLLECTIONS = new HashSet<Class>(Arrays.asList(List.class, Set.class));
    private final Object invocationInstance;
    private final String name;
    private final List<String> aliases;
    private final String description;
    private final Syntax syntax;
    private final AnnotatedElement annotatedElement;
    private final RegistryContainer<D, S> registryContainer;
    private final SuggestionRegistry<S> suggestionRegistry;
    private final ArgumentRegistry<S> argumentRegistry;
    private final CommandOptions<D, S> commandOptions;
    private final CommandMeta parentMeta;

    AbstractCommandProcessor(@NotNull Object invocationInstance, @NotNull AnnotatedElement annotatedElement, @NotNull RegistryContainer<D, S> registryContainer, @NotNull CommandOptions<D, S> commandOptions, @NotNull CommandMeta parentMeta) {
        this.invocationInstance = invocationInstance;
        this.annotatedElement = annotatedElement;
        this.name = this.nameOf();
        this.aliases = this.aliasesOf();
        this.description = this.descriptionOf();
        this.parentMeta = parentMeta;
        this.commandOptions = commandOptions;
        this.registryContainer = registryContainer;
        this.suggestionRegistry = registryContainer.getSuggestionRegistry();
        this.argumentRegistry = registryContainer.getArgumentRegistry();
        this.syntax = annotatedElement.getAnnotation(Syntax.class);
    }

    @Override
    @NotNull
    public RegistryContainer<D, S> getRegistryContainer() {
        return this.registryContainer;
    }

    @Override
    @NotNull
    public CommandOptions<D, S> getCommandOptions() {
        return this.commandOptions;
    }

    @NotNull
    protected CommandMeta getParentMeta() {
        return this.parentMeta;
    }

    @Override
    @Nullable
    public Syntax getSyntaxAnnotation() {
        return this.syntax;
    }

    @Contract(value="_ -> new")
    @NotNull
    protected SubCommandRegistrationException createException(@NotNull String message) {
        return new SubCommandRegistrationException(message, this.annotatedElement, this.invocationInstance.getClass());
    }

    @Nullable
    private String nameOf() {
        Command commandAnnotation = this.annotatedElement.getAnnotation(Command.class);
        if (commandAnnotation == null) {
            return null;
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, commandAnnotation.value());
    }

    @Nullable
    private List<String> aliasesOf() {
        Command commandAnnotation = this.annotatedElement.getAnnotation(Command.class);
        if (commandAnnotation == null) {
            return null;
        }
        return Arrays.stream(commandAnnotation.alias()).map(it -> CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, it)).collect(Collectors.toList());
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    protected InternalArgument<S, ?> argumentFromParameter(@NotNull CommandMeta meta, @NotNull Parameter parameter, @NotNull List<String> argDescriptions, @NotNull Map<Integer, Suggestion<S>> suggestions, @NotNull ArgumentGroup<Flag> flagGroup, @NotNull ArgumentGroup<Argument> argumentGroup, int position) {
        Class<?> type = parameter.getType();
        String argumentName = this.getArgName(parameter);
        String argumentDescription = this.getArgumentDescription(argDescriptions, parameter, position);
        boolean optional = parameter.isAnnotationPresent(Optional.class);
        if (SUPPORTED_COLLECTIONS.stream().anyMatch(it -> it.isAssignableFrom(type))) {
            Class<?> collectionType = this.getGenericType(parameter);
            StringInternalArgument<S> argument = this.createSimpleArgument(meta, collectionType, argumentName, argumentDescription, suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), true);
            if (argument instanceof UnknownInternalArgument) {
                throw this.createException("No internalArgument of type \"" + argument.getType().getName() + "\" registered");
            }
            if (parameter.isAnnotationPresent(Split.class)) {
                Split splitAnnotation = parameter.getAnnotation(Split.class);
                return new SplitStringInternalArgument<S>(meta, argumentName, argumentDescription, splitAnnotation.value(), argument, type, suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), optional);
            }
            return new CollectionInternalArgument<S>(meta, argumentName, argumentDescription, argument, type, suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), optional);
        }
        if (type == String.class && parameter.isAnnotationPresent(Join.class)) {
            Join joinAnnotation = parameter.getAnnotation(Join.class);
            return new JoinedStringInternalArgument<S>(meta, argumentName, argumentDescription, joinAnnotation.value(), suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), optional);
        }
        if (Keyed.class.isAssignableFrom(type)) {
            if (type == Arguments.class) {
                if (argumentGroup.isEmpty()) {
                    throw this.createException("No named arguments found, if you want only Flags use the \"" + Flags.class.getSimpleName() + "\" argument instead");
                }
            } else if (type == Flags.class && flagGroup.isEmpty()) {
                throw this.createException("No declared flags found, make sure you have registered or declared some, or make sure the key is correct.");
            }
            return new KeyedInternalArgument<S>(meta, argumentName, argumentDescription, this.createFlagInternals(meta, flagGroup), this.createNamedArgumentInternals(meta, argumentGroup), flagGroup, argumentGroup);
        }
        return this.createSimpleArgument(meta, type, argumentName, argumentDescription, suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), optional);
    }

    @NotNull
    protected StringInternalArgument<S> createSimpleArgument(@NotNull CommandMeta meta, @NotNull Class<?> type, @NotNull String name, @NotNull String description, @NotNull Suggestion<S> suggestion, boolean optional) {
        ArgumentResolver<S> resolver = this.argumentRegistry.getResolver(type);
        if (resolver == null) {
            if (Enum.class.isAssignableFrom(type)) {
                return new EnumInternalArgument<S>(meta, name, description, (Class<Enum<?>>)type, suggestion, optional);
            }
            InternalArgument.Factory<S> factory = this.argumentRegistry.getFactory(type);
            if (factory != null) {
                return factory.create(meta, name, description, type, suggestion, optional);
            }
            return new UnknownInternalArgument(type);
        }
        return new ResolverInternalArgument<S>(meta, name, description, type, resolver, suggestion, optional);
    }

    private Map<Flag, StringInternalArgument<S>> createFlagInternals(@NotNull CommandMeta meta, @NotNull ArgumentGroup<Flag> group) {
        HashMap<Flag, StringInternalArgument<S>> internalArguments = new HashMap<Flag, StringInternalArgument<S>>();
        for (Flag flag : group.getAll()) {
            Class<?> argType = flag.getArgument();
            if (argType == null) continue;
            Suggestion<S> suggestion = this.createSuggestion(flag.getSuggestion(), argType);
            internalArguments.put(flag, this.createSimpleArgument(meta, argType, "", flag.getDescription(), suggestion, true));
        }
        return internalArguments;
    }

    private Map<Argument, StringInternalArgument<S>> createNamedArgumentInternals(@NotNull CommandMeta meta, @NotNull ArgumentGroup<Argument> group) {
        HashMap<Argument, StringInternalArgument<S>> internalArguments = new HashMap<Argument, StringInternalArgument<S>>();
        for (Argument argument : group.getAll()) {
            Class<?> argType = argument.getType();
            Suggestion<S> suggestion = this.createSuggestion(argument.getSuggestion(), argType);
            if (argument instanceof ListArgument) {
                ListArgument listArgument = (ListArgument)argument;
                StringInternalArgument<S> internalArgument = this.createSimpleArgument(meta, listArgument.getType(), listArgument.getName(), listArgument.getDescription(), suggestion, true);
                internalArguments.put(argument, new SplitStringInternalArgument<S>(meta, listArgument.getName(), listArgument.getDescription(), listArgument.getSeparator(), internalArgument, listArgument.getType(), suggestion, true));
                continue;
            }
            internalArguments.put(argument, this.createSimpleArgument(meta, argType, argument.getName(), argument.getDescription(), suggestion, true));
        }
        return internalArguments;
    }

    @NotNull
    private String getArgName(@NotNull Parameter parameter) {
        if (parameter.isAnnotationPresent(ArgName.class)) {
            return parameter.getAnnotation(ArgName.class).value();
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, parameter.getName());
    }

    @NotNull
    private String getArgumentDescription(List<String> argDescriptions, @NotNull Parameter parameter, int index) {
        Description description = parameter.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        if (index < argDescriptions.size()) {
            return argDescriptions.get(index);
        }
        return "";
    }

    @NotNull
    private String descriptionOf() {
        Class<?> commandClass = this.invocationInstance.getClass();
        Description descriptionAnnotation = commandClass.getAnnotation(Description.class);
        if (descriptionAnnotation != null) {
            return descriptionAnnotation.value();
        }
        return "";
    }

    @NotNull
    private Class<?> getGenericType(@NotNull Parameter parameter) {
        Class<?> type = parameter.getType();
        if (SUPPORTED_COLLECTIONS.stream().anyMatch(it -> it.isAssignableFrom(type))) {
            ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
            Type[] types = parameterizedType.getActualTypeArguments();
            if (types.length != 1) {
                throw this.createException("Unsupported collection type \"" + type + "\"");
            }
            Type genericType = types[0];
            return (Class)(genericType instanceof WildcardType ? ((WildcardType)genericType).getUpperBounds()[0] : genericType);
        }
        return type;
    }

    @NotNull
    protected Suggestion<S> createSuggestion(@Nullable SuggestionKey suggestionKey, @NotNull Class<?> type) {
        if (suggestionKey == null || suggestionKey.getKey().isEmpty()) {
            if (Enum.class.isAssignableFrom(type)) {
                return new EnumSuggestion(type, this.commandOptions.suggestLowercaseEnum());
            }
            Pair<SuggestionResolver<S>, SuggestionMethod> pair = this.suggestionRegistry.getSuggestionResolver(type);
            if (pair != null) {
                return new SimpleSuggestion<S>(pair.first(), pair.second());
            }
            return new EmptySuggestion();
        }
        Pair<SuggestionResolver<S>, SuggestionMethod> pair = this.suggestionRegistry.getSuggestionResolver(suggestionKey);
        if (pair == null) {
            throw this.createException("Cannot find the suggestion key `" + suggestionKey + "`");
        }
        return new SimpleSuggestion<S>(pair.first(), pair.second());
    }

    @NotNull
    private Suggestion<S> suggestionFromParam(@NotNull Parameter parameter) {
        dev.triumphteam.cmd.core.annotations.Suggestion parameterAnnotation = parameter.getAnnotation(dev.triumphteam.cmd.core.annotations.Suggestion.class);
        SuggestionKey suggestionKey = parameterAnnotation == null ? null : SuggestionKey.of(parameterAnnotation.value());
        Class<?> type = this.getGenericType(parameter);
        return this.createSuggestion(suggestionKey, type);
    }
}

