/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.extention.sender;

import dev.triumphteam.cmd.core.extention.ValidationResult;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.extention.sender.SenderMapper;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.message.context.MessageContext;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface SenderExtension<D, S>
extends SenderMapper<D, S> {
    @NotNull
    public Set<Class<? extends S>> getAllowedSenders();

    @NotNull
    public @NotNull ValidationResult<@NotNull MessageKey<@NotNull MessageContext>> validate(@NotNull CommandMeta var1, @NotNull Class<?> var2, @NotNull S var3);

    default public ValidationResult<@NotNull MessageKey<@NotNull MessageContext>> valid() {
        return new ValidationResult.Valid<MessageKey<MessageContext>>();
    }

    default public ValidationResult<@NotNull MessageKey<@NotNull MessageContext>> invalid(@NotNull @NotNull MessageKey<@NotNull MessageContext> messageKey) {
        return new ValidationResult.Invalid<MessageKey<MessageContext>>(messageKey);
    }

    public static interface Default<S>
    extends SenderExtension<S, S> {
        @Override
        @NotNull
        default public @NotNull ValidationResult<@NotNull MessageKey<@NotNull MessageContext>> validate(@NotNull CommandMeta meta, @NotNull Class<?> allowedSender, @NotNull S sender) {
            return this.valid();
        }

        @Override
        @NotNull
        default public S map(@NotNull S defaultSender) {
            return defaultSender;
        }

        @Override
        @NotNull
        default public S mapBackwards(@NotNull S sender) {
            return sender;
        }
    }
}

