/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.extention.registry;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import dev.triumphteam.cmd.core.argument.ArgumentResolver;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.extention.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArgumentRegistry<S>
implements Registry {
    private final Map<Class<?>, ArgumentResolver<S>> arguments = new HashMap();
    private final Map<Class<?>, InternalArgument.Factory<S>> internals = new HashMap();

    public ArgumentRegistry() {
        this.register(Short.TYPE, (S sender, String arg) -> Ints.tryParse((String)arg));
        this.register(Short.class, (S sender, String arg) -> Ints.tryParse((String)arg));
        this.register(Integer.TYPE, (S sender, String arg) -> Ints.tryParse((String)arg));
        this.register(Integer.class, (S sender, String arg) -> Ints.tryParse((String)arg));
        this.register(Long.TYPE, (S sender, String arg) -> Longs.tryParse((String)arg));
        this.register(Long.class, (S sender, String arg) -> Longs.tryParse((String)arg));
        this.register(Float.TYPE, (S sender, String arg) -> Floats.tryParse((String)arg));
        this.register(Float.class, (S sender, String arg) -> Floats.tryParse((String)arg));
        this.register(Double.TYPE, (S sender, String arg) -> Doubles.tryParse((String)arg));
        this.register(Double.class, (S sender, String arg) -> Doubles.tryParse((String)arg));
        this.register(Boolean.TYPE, (S sender, String arg) -> Boolean.valueOf(arg));
        this.register(Boolean.class, (S sender, String arg) -> Boolean.valueOf(arg));
        this.register(String.class, (S sender, String arg) -> arg);
    }

    public void register(@NotNull Class<?> clazz, @NotNull ArgumentResolver<S> argument) {
        this.arguments.put(clazz, argument);
    }

    public void register(@NotNull Class<?> clazz, @NotNull InternalArgument.Factory<S> factory) {
        this.internals.put(clazz, factory);
    }

    @Nullable
    public ArgumentResolver<S> getResolver(@NotNull Class<?> clazz) {
        return this.arguments.get(clazz);
    }

    @Nullable
    public InternalArgument.Factory<S> getFactory(@NotNull Class<?> clazz) {
        return this.internals.get(clazz);
    }
}

