/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.extention.meta;

import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.extention.meta.MetaKey;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImmutableCommandMeta
implements CommandMeta {
    private final CommandMeta parentMeta;
    private final Map<MetaKey<?>, Object> meta;

    public ImmutableCommandMeta(@Nullable CommandMeta parentMeta, @NotNull Map<MetaKey<?>, Object> meta) {
        this.parentMeta = parentMeta;
        this.meta = meta;
    }

    @Override
    @NotNull
    public <V> Optional<V> get(@NotNull MetaKey<V> metaKey) {
        return Optional.ofNullable(this.getNullable(metaKey));
    }

    @Override
    @Nullable
    public <V> V getNullable(@NotNull MetaKey<V> metaKey) {
        return (V)this.meta.get(metaKey);
    }

    @Override
    public <V> V getOrDefault(@NotNull MetaKey<V> metaKey, @Nullable V def) {
        return (V)this.meta.getOrDefault(metaKey, def);
    }

    @Override
    public <V> boolean isPresent(@NotNull MetaKey<V> metaKey) {
        return this.meta.containsKey(metaKey);
    }

    @Override
    @Nullable
    public CommandMeta getParentMeta() {
        return this.parentMeta;
    }

    public String toString() {
        return "ImmutableCommandMeta{meta=" + this.meta + '}';
    }
}

