/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.extention.meta;

import dev.triumphteam.cmd.core.extention.meta.ImmutableCommandMeta;
import dev.triumphteam.cmd.core.extention.meta.MetaKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommandMeta {
    @NotNull
    public <V> Optional<V> get(@NotNull MetaKey<V> var1);

    @Nullable
    public <V> V getNullable(@NotNull MetaKey<V> var1);

    @Contract(value="_, null -> null; _, !null -> !null")
    public <V> V getOrDefault(@NotNull MetaKey<V> var1, @Nullable V var2);

    public <V> boolean isPresent(@NotNull MetaKey<V> var1);

    @Nullable
    public CommandMeta getParentMeta();

    public static final class Builder
    implements CommandMeta {
        private final Map<MetaKey<?>, Object> metaMap = new HashMap();
        private final CommandMeta parentMeta;

        public Builder(@Nullable CommandMeta parentMeta) {
            this.parentMeta = parentMeta;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public <V> Builder add(@NotNull MetaKey<V> metaKey, @Nullable V value) {
            this.metaMap.put(metaKey, value);
            return this;
        }

        @Contract(value="_, -> this")
        @NotNull
        public <V> Builder add(@NotNull MetaKey<V> metaKey) {
            return this.add(metaKey, null);
        }

        @Override
        @NotNull
        public <V> Optional<V> get(@NotNull MetaKey<V> metaKey) {
            return Optional.ofNullable(this.getNullable(metaKey));
        }

        @Override
        @Nullable
        public <V> V getNullable(@NotNull MetaKey<V> metaKey) {
            return (V)this.metaMap.get(metaKey);
        }

        @Override
        @Nullable
        public <V> V getOrDefault(@NotNull MetaKey<V> metaKey, @Nullable V def) {
            return (V)this.metaMap.getOrDefault(metaKey, def);
        }

        @Override
        public <V> boolean isPresent(@NotNull MetaKey<V> metaKey) {
            return this.metaMap.containsKey(metaKey);
        }

        @Override
        @Nullable
        public CommandMeta getParentMeta() {
            return this.parentMeta;
        }

        @Contract(value=" -> new")
        @NotNull
        public CommandMeta build() {
            return new ImmutableCommandMeta(this.parentMeta, Collections.unmodifiableMap(this.metaMap));
        }
    }
}

