/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.extention.command;

import dev.triumphteam.cmd.core.extention.command.Settings;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.extention.registry.MessageRegistry;
import dev.triumphteam.cmd.core.extention.sender.SenderMapper;
import dev.triumphteam.cmd.core.requirement.Requirement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableSettings<D, S>
implements Settings<D, S> {
    private final List<Requirement<D, S>> requirements;

    public ImmutableSettings(@NotNull List<Requirement<D, S>> requirements) {
        this.requirements = requirements;
    }

    @Override
    public boolean testRequirements(@NotNull MessageRegistry<S> messageRegistry, @NotNull S sender, @NotNull CommandMeta meta, @NotNull SenderMapper<D, S> senderMapper) {
        Requirement<D, S> requirement = this.getFailedRequirement(sender, meta, senderMapper);
        if (requirement == null) {
            return true;
        }
        requirement.onDeny(sender, messageRegistry, meta);
        return false;
    }

    @Override
    public boolean testRequirements(@NotNull S sender, @NotNull CommandMeta meta, @NotNull SenderMapper<D, S> senderMapper) {
        return this.getFailedRequirement(sender, meta, senderMapper) == null;
    }

    @Nullable
    private Requirement<D, S> getFailedRequirement(@NotNull S sender, @NotNull CommandMeta meta, @NotNull SenderMapper<D, S> senderMapper) {
        for (Requirement<D, S> requirement : this.requirements) {
            if (requirement.test(sender, meta, senderMapper)) continue;
            return requirement;
        }
        return null;
    }
}

